;------------------------------
; memalloc.asm by KIP COOLEY

;Here's a quick program that figures out our program image size, resizes
;our memory allocation to this, allocates additional memory, and
;releases this additional memory.  I wrote it in full segment definition
;since I don't know which assembler you are using, think of it as being
;universal.  ;>


;Small memory model segment definitions and link order.  (Same as using
;the .MODEL SMALL and .DOSSEG directives in MASM.)

_TEXT   SEGMENT WORD PUBLIC 'CODE'
_TEXT   ENDS
_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS
STACK   SEGMENT PARA STACK 'STACK'
STACK   ENDS

DGROUP  GROUP   _DATA, CONST, _BSS, STACK

;Program Segment Prefix (PSP) image with a sample location.

PSP     SEGMENT AT 0

        ORG     0080h

CommandTail     db 128 DUP (?)

PSP     ENDS

;Define the size of the stack.  (.STACK 2048)

STACK   SEGMENT

                dw 1024 DUP (?) ;2 KB stack

STACK   ENDS

;Segment to hold pertinent data.  (.DATA)

_DATA   SEGMENT

NewBlockSeg     dw 0            ;Segment address of additional memory

_DATA   ENDS

;Start of coding.  (.CODE and .STARTUP)  The ASSUME is set to the
;initial parameters when an .EXE file gains control.  We then set
;DS to DGROUP (near data group) and normalize the stack to DGROUP.

_TEXT   SEGMENT

        ASSUME  cs:_TEXT, ds:PSP, es:PSP, ss:STACK

Load:   mov     dx,DGROUP       ;Point to our data area
        mov     ds,dx

        ASSUME  ds:DGROUP       ;Inform assembler of change

        mov     ax,ss           ;Base of stack minus base of DGROUP
        sub     ax,dx           ;  equals number of paras to add to
        mov     cl,4            ;  stack to offset it from DGROUP
        shl     ax,cl           ;Convert paragraphs to bytes
        cli                     ;For 8086 CPUs
        mov     ss,dx           ;Normalize stack
        add     sp,ax
        sti                     ;Restore interrupts

        ASSUME  ss:DGROUP       ;Inform assembler of change

;The program image size must be in paragraphs.  We first calculate how
;many paragraphs are from the base of the program (PSP is it) to the
;base of our stack (usually the last segment in a program but not
;always).  Then we get the length of the stack (or DGROUP and the stack
;if it was normalized (it was)) and convert it from bytes to paragraphs.
;We check to see if the stack top is paragraph-aligned.  If not, we
;add a para to cover the odd-sized stack and convert it.

        mov     bx,ss           ;Base of stack minus
        mov     ax,es           ;  start of PSP equals
        sub     bx,ax           ;  partial size of program in paras
        mov     ax,sp           ;Get size of stack (or normalized size)
        test    ax,0Fh          ;Is top paragraph-aligned?
        jz      Load02          ; Yes - No adjustments needed
        add     ax,10h          ; No  - Add a para to cover odd size
Load02: mov     cl,4
        shr     ax,cl           ;Convert bytes into paragraphs
        add     bx,ax           ;Size of program image in paras
        mov     ah,4Ah          ;DOS: Resize Memory Block
        int     21h
        jnc     Load04          ;No errors encountered

;Include necessary error trapping for AX=0007 Memory blocks damaged,
;AX=0008 Insufficient memory, or AX=0009 Memory block address invalid.

;Now we want to allocate 64,016 bytes (4001 paragraphs) to our program.

Load04: mov     bx,64016/16
        mov     ah,48h          ;DOS: Allocate Memory Block
        int     21h
        jnc     Load06          ;No errors encountered

;Include necessary error trapping for AX=0007 Memory blocks damaged
;or AX=0008 Insufficient memory.

Load06: mov     [NewBlockSeg],ax  ;Save segment start of allocation

;All done with our allocated block of memory, let's release it.

        mov     ax,[NewBlockSeg]  ;Point to block to deallocate
        mov     es,ax
        mov     ah,49h          ;DOS: Release Memory Block
        int     21h
        jnc     Exit            ;No errors encountered, let's go home

;Include necessary error trapping for AX=0007 Memory blocks damaged
;or AX=0009 Memory block address invalid.  Not necessary if exiting
;program since DOS deallocates all memory attached to it, but an
;errorlevel can be sent to signify problems.

Exit:   mov     ax,4C00h        ;DOS: Terminate with Errorlevel 0
        int     21h

_TEXT   ENDS

        END     LOAD

