;* FADE.ASM - Clear VGA text screen by fading out.
;* Written by Dave M. Walker (1:396/1)
;* Released into the public domain

cseg segment
assume cs:cseg
org 100h                       ; .COM format

PEL_Read_Reg    EQU     03C7h                   ;Palette read access
PEL_Write_Reg   EQU     03C8h                   ;Palette write access
PEL_Data_Reg    EQU     03C9h                   ;Palette data register

Start:          jmp     Begin

ColorTable      db       0                      ; 0 =>  0
                db       1                      ; 1 =>  1
                db       2                      ; 2 =>  2
                db       3                      ; 3 =>  3
                db       4                      ; 4 =>  4
                db       5                      ; 5 =>  5
                db      20                      ; 6 => 20
                db       7                      ; 7 =>  7
                db      56                      ; 8 => 56
                db      57                      ; 9 => 57
                db      58                      ;10 => 58
                db      59                      ;11 => 59
                db      60                      ;12 => 60
                db      61                      ;13 => 61
                db      62                      ;14 => 62
                db      63                      ;15 => 63

OrigPalette     db      3*16 dup (?)            ;Original palette
FadePalette     db      3*16 dup (?)            ;Current fade palette

Begin:          mov     ax,0B800h               ;Set ES to video seg
                mov     es,ax
                mov     bx,OFFSET ColorTable    ;Setup BX for color xlat

                xor     ah,ah                   ;Start with color 0
                mov     si,OFFSET OrigPalette
GetColorsLoop:  mov     dx,PEL_Read_Reg
                mov     al,ah                   ;AL = Color
                xlatb                           ;Translate to palette index
                out     dx,al                   ;Send palette index
                mov     dx,PEL_Data_Reg
                mov     cx,3                    ;Read 3 values (RGB)
GetColors:      in      al,dx                   ;Get data
                mov     [si],al                 ;Store in OrigPalette
                mov     [si+3*16],al            ;Store in FadePalette
                inc     si                      ;Bump pointer
                loop    GetColors
                inc     ah                      ;Bump color
                cmp     ah,10h                  ;Done yet?
                jne     GetColorsLoop

DecPalette:     mov     si,OFFSET FadePalette   ;Point to fade values
                mov     cx,3*16                 ;Repeat 3 bytes * 16 colors
                mov     ah,-1                   ;Done flag = -1 (True)
DecPalLoop:     mov     al,[si]                 ;Get fade value
                or      al,al                   ;Is it zero?
                je      RegZero                 ;If so, skip fade
                dec     byte ptr [si]           ;Decrement fade value
                xor     ah,ah                   ;Make flag false
RegZero:        inc     si                      ;Next value
                loop    DecPalLoop
                or      ah,ah                   ;Done yet?
                jnz     ClearScreen             ;Jump if so

                xor     ah,ah                   ;Start with color 0
                mov     si,OFFSET FadePalette   ;Point to fade values
Rotate:         mov     dx,PEL_Write_Reg
                mov     al,ah                   ;AL = Color
                xlatb                           ;Translate to palette index
                out     dx,al                   ;Send palette index
                mov     dx,PEL_Data_Reg
                mov     cx,3                    ;Write 3 values
RotateLoop:     mov     al,[si]                 ;Get fade value
                out     dx,al                   ;Send it
                inc     si                      ;Bump pointer
                loop    RotateLoop
                inc     ah                      ;Bump color
                cmp     ah,10h                  ;Done yet?
                jne     Rotate

                push    ds                      ;Simple BIOS delay
                mov     ax,0040h                ;Approx. 1/18.2 sec.
                mov     ds,ax
                mov     al,ds:[006Ch]
DelayLoop:      cmp     al,ds:[006Ch]
                je      DelayLoop
                pop     ds

                jmp     DecPalette              ;Continue fading

ClearScreen:    mov     ax,0720h                ;Clear text screen
                xor     di,di
                mov     cx,80*25
                cld
                rep stosw

                xor     ah,ah                   ;Color 0
                mov     si,OFFSET OrigPalette   ;Point to original palette
ResPalLoop:     mov     dx,PEL_Write_Reg
                mov     al,ah                   ;AL = Color
                xlatb                           ;Translate to palette index
                out     dx,al                   ;Send it
                mov     dx,PEL_Data_Reg
                mov     cx,3                    ;Write 3 values
ResColor:       mov     al,[si]                 ;Get value
                out     dx,al                   ;Send value
                inc     si                      ;Bump pointer
                loop    ResColor
                inc     ah                      ;Bump color
                cmp     ah,10h                  ;Done yet?
                jne     ResPalLoop

                mov     ax,4C00h                ;Exit to DOS
                int     21h

cseg ends
end Start
