;==============================================================================
; Oscillogram for SoundBlaster v1.0
;	Craig Jackson
;------------------------------------------------------------------------------
; Assembler   : MASM 6.10
; Requirements: 8086, DOS 1.0, VGA/MCGA, SoundBlaster (see BASEADDR)
; Supports	  : Microphone, Line, CD
; Resolutions : 8-bit, 16-bit

	.MODEL tiny
	.8086
	.DOSSEG

	BASEADDR  EQU 0220h 				;SoundBlaster base address
	VIDEOCOLS EQU 320					;Video columns
	VIDEOROWS EQU 200					;Video rows

	.STACK 0100h

	.DATA
cMultiplier  db  VIDEOCOLS/2			;Video columns scalar for sample range

	.CODE
	.STARTUP

	; Initialize graphics
	mov 	ax,00013h					;Set video mode (320x200x256)
	int 	010h						;	Interrupt: Video
	mov 	ax,0A000h					;AX = Video segment
	mov 	es,ax						;ES = Video segment

loopMain:
	; Clear screen
	xor 	di,di						;DI = Offset to start of video
	mov 	cx,VIDEOCOLS * (VIDEOROWS - (256-VIDEOROWS)/2) / SIZEOF(WORD)
										;CX = Count of video words
	xor 	ax,ax						;AX = 0:0
	rep 	stosw						;Clear screen

	; Draw oscillogram
	mov 	cx,VIDEOCOLS				;CX = Video columns
	mov 	di,((VIDEOROWS-128)/2)*VIDEOCOLS ;DI = Offset for first video column
loopRefresh:
	mov 	dx,BASEADDR+00Ch			;DX = DSP Write Data or Command
	mov 	al,020h 					;AL = Direct ADC
	out 	dx,al						;	Output: DSP Write Data or Command

	; Vertical retrace synchronization
	mov 	dx,003DAh					;DX = Input Status One (VGA)
@@: in		al,dx						;AL = Status byte
	test	al,008h 					;Check for retrace finish
	jnz 	@B							;	Jump: Poll retrace finish
@@: in		al,dx						;AL = Status byte
	test	al,008h 					;Check for retrace start
	jz		@B							;	Jump: Poll retrace start

	mov 	dx,BASEADDR+00Ah			;DX = DSP Read Data
	in		al,dx						;AL = ADC Data (high byte on SB16)
	and 	al,0FEh 					;AL = ADC Data forced even

	push	di							;Preserve DI
	mul 	BYTE PTR cMultiplier		;AX = Video row offset for sample
	add 	di,ax						;DI = Video offset to pixel
	mov 	ax,00107h					;AH = Check for character function
										;AL = Color for oscillogram
	stosb								;Store sample
	pop 	di							;Restore DI

	inc 	di							;DI = Offset for next video column
	int 	016h						;	Interrupt: Keyboard
	loopz	loopRefresh 				;	Loop: Continue sampling loop, until keypress
	jz		loopMain					;	Jump: Refresh screen, until keypress

	; Terminate program
	xor 	ah,ah						;Read character, flush keypress
	int 	016h						;	Interrupt: Keyboard

	mov 	ax,00003h					;Set video mode (80x25x16)
	int 	010h						;	Interrupt: Video

	ret 								;Terminate program (old style)

	 END
