--::::::::::
--roomline.adb
--::::::::::
WITH Text_IO;
WITH Chop;
WITH Phil;
WITH Calendar;
--PRAGMA Elaborate(Phil);
PACKAGE BODY Room IS
 
-- A line-oriented version of the Room package, for line-oriented
-- terminals like IBM 3270's where the user cannot do ASCII screen control.
-- This is the only file in the dining philosophers system that needs
-- changing to use in a line-oriented environment.
-- Michael B. Feldman, The George Washington University, November 1990.
 
 
  Phils:      ARRAY(Table_Type) OF Phil.Philosopher;
 
  TYPE Phil_Names IS (Dijkstra, Texel, Booch, Ichbiah, Stroustrup);
 
  TASK BODY Head_Waiter IS
 
    T : Integer;
    Start_Time: Calendar.Time;
    Phil_Names: CONSTANT ARRAY(1..5) OF String(1..18) :=
     ("Eddy Dijkstra     ",
      "Putnam Texel      ",
      "Grady Booch       ",
      "Jean Ichbiah      ",
      "Bjarne Stroustrup ");
    Blanks : CONSTANT String := "     ";
 
  BEGIN
 
    ACCEPT Open_The_Room;
    Start_Time := Calendar.Clock;
 
    Phils(1).Come_To_Life(1,1,2);
    Phils(3).Come_To_Life(3,3,4);
    Phils(2).Come_To_Life(2,2,3);
    Phils(5).Come_To_Life(5,1,5);
    Phils(4).Come_To_Life(4,4,5);
 
    LOOP
      SELECT
        ACCEPT Report_State(Which_Phil: Table_Type;
                         State: Phil.States;
                         How_Long: Natural := 0) DO
          T := Integer(Calendar."-"(Calendar.Clock,Start_Time));
          Text_IO.Put( "T=" & Integer'Image(T) & " "
            & Blanks(1..Which_Phil) & Phil_Names(Which_Phil));
 
          CASE State IS
 
            WHEN Phil.Breathing =>
              Text_IO.Put("Breathing");
            WHEN Phil.Thinking =>
              Text_IO.Put( "Thinking"
                         & Integer'Image(How_Long)
                         & " seconds.");
            WHEN Phil.Eating =>
              Text_IO.Put( "Eating"
                         & Integer'Image(How_Long)
                         & " seconds.");
            WHEN Phil.Done_Eating =>
              Text_IO.Put("Yum-yum (burp)");
            WHEN Phil.Got_One_Stick =>
              Text_IO.Put( "First chopstick"
                          & Integer'Image(How_Long));
            WHEN Phil.Got_Other_Stick =>
              Text_IO.Put( "Second chopstick"
                          & Integer'Image(How_Long));
 
          END CASE;
          Text_IO.New_Line;
 
         END Report_State;
        OR
          TERMINATE;
        END SELECT;
 
      END LOOP;
 
    END Head_Waiter;
 
END Room;

