WITH Ada.Text_IO; USE Ada.Text_IO;
WITH Currency; USE Currency;
WITH Dates; USE Dates;
WITH Persons; USE Persons;
WITH Personnel; USE Personnel;
WITH Payroll; USE Payroll;
PROCEDURE Use_Payroll IS
------------------------------------------------------------------
--| Demonstrates the use of tagged types
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
  
  -- demonstrates the use of tagged types
  
  George: Person;
  Mary  : Employee;
  Martha: Professional;
  Virginia: Sales;
  Herman: Clerical;
  
BEGIN

  -- first construct all the people
  
  George := Persons.Constructors.MakePerson(
             Name      => "George",
             Gender    => Male,
             BirthDate => Date_Of(1971,Nov,2));

  Mary := Personnel.Constructors.MakeEmployee(
             Name      => "Mary",  
             Gender    => Female,
             BirthDate => Date_Of(1950,Oct,21),
             ID        => 1234,
             StartDate => Date_Of(1989,Jul,1));
 
  Martha := Payroll.Constructors.MakeProfessional(
             Name        => "Martha",
             Gender      => Female,
             BirthDate   => Date_Of(1947,Jul,8),
             ID          => 2222,
             StartDate   => Date_Of(1985,Jun,6),
             MonthSalary => MakeCurrency(50000.00));

  Virginia := Payroll.Constructors.MakeSales(
             Name       => "Virginia",
             Gender     => Female,
             BirthDate  => Date_Of(1955,Feb,1),
             ID         => 3456,
             StartDate  => Date_Of(1990,Jan,1),
             WeekSalary => MakeCurrency(2500.00),
             CommRate   => 0.25); 
 
  Herman := Payroll.Constructors.MakeClerical(
             Name       => "Herman",
             Gender     => Male,
             BirthDate  => Date_Of(1975,May,13),
             ID         => 1557,
             StartDate  => Date_Of(1991,Jul,1),
             HourlyWage => MakeCurrency(7.50));
  
  -- Now display them all. Note that each Put is a different
  -- primitive operation.
  
  Put(Item => George);
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Mary);  
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Martha);
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Virginia);
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Herman);  
  Ada.Text_IO.Put_Line(Item => "------------------------");
 
END Use_Payroll; 
