PACKAGE BODY Useful_Functions IS
------------------------------------------------------------------
--| Body of Useful_Functions package
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995
------------------------------------------------------------------

  -- minimum of two Integer values
  FUNCTION Minimum (Value1: Integer; Value2: Integer) RETURN Integer IS
    Result: Integer;
  BEGIN -- Minimum
    IF Value1 < Value2 THEN
       Result := Value1;
    ELSE
       Result := Value2;
    END IF;
    RETURN Result;
  END Minimum;

  -- minimum of two Float values
  FUNCTION Minimum (Value1: Float; Value2: Float) RETURN Float IS
    Result: Float;
  BEGIN -- Minimum
    IF Value1 < Value2 THEN
       Result := Value1;
    ELSE
       Result := Value2;
    END IF;
    RETURN Result;
  END Minimum;

  -- maximum of two Integer values
  FUNCTION Maximum (Value1: Integer; Value2: Integer) RETURN Integer IS
    Result: Integer;
  BEGIN -- Maximum
    IF Value1 > Value2 THEN
       Result := Value1;
    ELSE
       Result := Value2;
    END IF;
    RETURN Result;
  END Maximum;

  -- maximum of two Float values
  FUNCTION Maximum (Value1: Float; Value2: Float) RETURN Float IS
    Result: Float;
  BEGIN -- Maximum
    IF Value1 > Value2 THEN
       Result := Value1;
    ELSE
       Result := Value2;
    END IF;
    RETURN Result;
  END Maximum;

  -- sum of integers from 1 to N
  FUNCTION Sum (N: Positive) RETURN Positive IS
    Result: Natural; 
  BEGIN -- Sum
    Result := 0;
    FOR Count IN 1..N LOOP
      Result := Result + Count;
    END LOOP;
    RETURN Result;
  END Sum;

  -- factorial, or product of integers from 1 to N
  FUNCTION Factorial (N: Positive) RETURN Positive IS
    Result: Positive;
  BEGIN -- Factorial
    Result := 1;
    FOR Count IN 1..N LOOP
      Result := Result * Count;
    END LOOP;
    RETURN Result;
  END Factorial;

END Useful_Functions;
