WITH Stacks_Generic;
FUNCTION StringReverse(S: String) RETURN String IS
------------------------------------------------------------------
--| Returns the reverse of a string, using a stack instead of recursion
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
  
  -- Pre: S is defined
  -- Post: returns the reverse of S

  PACKAGE Char_Stacks IS 
    NEW Stacks_Generic(StackElement => Character);
  USE Char_Stacks;

  OneStack: Stack;
  Result: String (S'Range);

BEGIN -- StringReverse

  IF S'Length <= 1 THEN
    RETURN S;
  END IF; 

  MakeEmpty (OneStack);

  FOR Count IN S'Range LOOP
    Push (OneStack, S(Count));
  END LOOP;

  FOR Count IN Result'Range LOOP
    Result (Count) := Top (OneStack);
    Pop (OneStack);
  END LOOP;

  RETURN Result;

END StringReverse;
