WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Dates.IO;
PACKAGE BODY Persons IS
------------------------------------------------------------------
--| Body of Persons package 
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  PACKAGE Gender_IO IS NEW Ada.Text_IO.Enumeration_IO(Enum => Genders);

  FUNCTION NameOf(Whom: Person) RETURN NameType IS
  BEGIN
    RETURN Whom.NameField;
  END NameOf; 

  FUNCTION GenderOf(Whom: Person) RETURN Genders IS
  BEGIN
    RETURN Whom.Gender;
  END GenderOf;

  FUNCTION DOBOf(Whom: Person) RETURN Date IS
  BEGIN
    RETURN Whom.BirthDate;  
  END DOBOf; 
 
  PROCEDURE Put(Item: Person) IS
  BEGIN
    Ada.Text_IO.Put(Item => "Name: ");
    Ada.Text_IO.Put(Item => Item.NameField(1..Item.NameLength));
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Gender: ");
    Gender_IO.Put(Item => Item.Gender, Set => Ada.Text_IO.Lower_Case);
    Ada.Text_IO.New_Line;

    Ada.Text_IO.Put(Item => "Birth Date: ");
    Dates.IO.Put(Item => Item.BirthDate, Format => Dates.IO.Full);
    Ada.Text_IO.New_Line;
  END Put;

  PACKAGE BODY Constructors IS
  
    FUNCTION MakePerson(Name     : String;
                        Gender   : Genders; 
                        BirthDate: Date) RETURN Person IS
      Temp: NameType;
    BEGIN -- MakePerson

      Temp(1..Name'Length) := Name;  -- copy into slice of Temp

      RETURN (NameLength => Name'Length,
              NameField => Temp,
              Gender    => Gender,
              BirthDate => BirthDate);
    END MakePerson;
  
  END Constructors;  

END Persons;   
