WITH Spiders;
USE Spiders;
PROCEDURE Draw_Many_Boxes IS
------------------------------------------------------------------
--| Draw several boxes with spiders - use loop
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  Spider1 : Spider;
  Spider2 : Spider;
  Spider3 : Spider;

BEGIN -- Draw_Many_Boxes    

  Debug(On);
  DrawRoom;

  Start (Which => Spider1, Row => 10, Col => 11,
                 WhichColor => Green, WhichWay => North);

  Start (Which => Spider2, Row => 10, Col => 11,
                 WhichColor => Blue, WhichWay => North);

  Right (Spider2);
  Jump  (Spider2, 4);

  Start (Which => Spider3, Row => 10, Col => 11,
                 WhichColor => Red, WhichWay => North);

  Right (Spider3);
  Right (Spider3);
  Right (Spider3);
  Jump  (Spider3, 3);

  FOR Side IN 1..4 LOOP
    FOR Count IN 1..3 LOOP
      Step (Spider1);
    END LOOP;
    Right (Spider1);
  END LOOP;

  FOR Side IN 1..4 LOOP
    FOR Count IN 1..4 LOOP
      Step (Spider2);
    END LOOP;
    Right (Spider2);
  END LOOP;

  FOR Side IN 1..4 LOOP
    FOR Count IN 1..5 LOOP
      Step (Spider3);
    END LOOP;
    Right (Spider3);
  END LOOP;

  Quit;

END Draw_Many_Boxes; 
