WITH Ada.Text_IO;
WITH Robust_Input;
WITH Ada.Integer_Text_IO;
PROCEDURE Display_Digits IS
------------------------------------------------------------------
--| Displays the digits of a nonnegative integer in reverse order.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------
  
  Base : CONSTANT Natural := 10;      -- number system base   
  Decimal : Natural;                  -- original number
  Digit :   Natural;                  -- each digit   

BEGIN  -- Display_Digits   

  Robust_Input.Get(Item=>Decimal, MinVal=>0, MaxVal => Natural'Last);

  -- Find and display remainders of Decimal divided by 10   
  Ada.Text_IO.Put(Item=> "The digits in reverse order are ");
  WHILE Decimal /= 0 LOOP
    -- invariant:
    -- Decimal in pass i is (Decimal in pass i-1) / Base (for i > 1)
    -- and Digit in pass i is (Decimal in pass i-1) REM Base (for i > 1)
    -- and Decimal >= 0

    Digit := Decimal REM Base;     -- Get next remainder   
    Ada.Integer_Text_IO.Put(Item => Digit, Width => 2);
    Decimal := Decimal / Base;     -- Get next quotient   

  END LOOP;
  -- assert: Decimal is zero   

  Ada.Text_IO.New_Line;

END Display_Digits;
