WITH Ada.Text_IO;
PROCEDURE Display_Days IS
------------------------------------------------------------------
--| display the days of the week, weekdays, weekend days;
--| demonstrate enumeration subtypes and how they can be used
--| to control a loop
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE Days IS (Mon, Tue, Wed, Thu, Fri, Sat, Sun);
  SUBTYPE WeekDays IS Days RANGE Mon .. Fri;
  SUBTYPE WeekEnd  IS Days RANGE Sat .. Sun;
  PACKAGE Day_IO IS 
     NEW Ada.Text_IO.Enumeration_IO (Enum => Days);
 
BEGIN -- Display_Days

  Ada.Text_IO.Put (Item => "The days of the week are ");
  FOR Day IN Days LOOP
    Day_IO.Put (Item => Day, Width => 4);
  END LOOP;
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put (Item => "The weekdays are ");
  FOR Day IN WeekDays LOOP
    Day_IO.Put (Item => Day, Width => 4);
  END LOOP;
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put (Item => "The weekend days are ");
  FOR Day IN WeekEnd LOOP
    Day_IO.Put (Item => Day, Width => 4);
  END LOOP;
  Ada.Text_IO.New_Line;

END Display_Days;
