WITH Ada.Calendar;
PACKAGE BODY Dates IS
------------------------------------------------------------------
--| body for package to represent calendar dates
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  FUNCTION Today RETURN Date IS
  -- Finds today's date and returns it as a record of type Date
  -- Today's date is gotten from PACKAGE Ada.Calendar
 
    Right_Now  : Ada.Calendar.Time;       -- holds internal clock value
    Temp       : Date; 
   
  BEGIN -- Today
 
    -- Get the current time value from the computer's clock
    Right_Now := Ada.Calendar.Clock;
 
    -- Extract the current month, day, and year from the time value 
    Temp.Month := Months'Val(Ada.Calendar.Month(Right_Now)- 1); 
    Temp.Day := Ada.Calendar.Day  (Right_Now);
    Temp.Year := Ada.Calendar.Year (Date => Right_Now);
 
    RETURN Temp;

  END Today;

  FUNCTION Date_Of(Year : Year_Number; 
                   Month : Months; 
                   Day : Day_Number) RETURN Date IS

  -- constructs a date given year, month, and day.

    Temp: Ada.Calendar.Time;

  BEGIN -- Date_Of

    Temp := Ada.Calendar.Time_Of(Year=>Year, 
                                 Month=>Months'Pos(Month)+1, Day=>Day);
    -- assert: M, D, and Y form a sensible date if Time_error not raised

    RETURN  (Month => Month, Year => Year, Day => Day);
    -- assert: a valid date is returned
  
  EXCEPTION
  
    WHEN Ada.Calendar.Time_Error =>
      RAISE Date_Error;

  END Date_Of;

  FUNCTION Year (D: Date) RETURN Year_Number IS
  BEGIN
    RETURN D.Year;
  END Year;

  FUNCTION Month (D: Date) RETURN Months IS
  BEGIN
    RETURN D.Month;
  END Month;

  FUNCTION Day (D: Date) RETURN Day_Number IS
  BEGIN
    RETURN D.Day;
  END Day;

END Dates;
