WITH Lists_Generic;
WITH Ada.Text_IO;
PROCEDURE Test_Lists_Generic IS
------------------------------------------------------------------
--| test program for generic one-way lists
--| illustrates how to use the basic operations of the package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  PACKAGE CharLists IS 
    NEW Lists_Generic (ElementType => Character);
  USE CharLists;
  
  C1, C2, C3: List;
  Ch: Character;
  
  PROCEDURE PrintList(L: List) IS
  -- Pre:  L is defined
  -- Post: displays the (character) contents of L
    Current: Position;
  BEGIN
    Current := First(L);
    WHILE NOT IsPastEnd(L, Current)  LOOP
      Ada.Text_IO.Put(Item => Retrieve(L, Current));
      GoAhead(L, Current);
    END LOOP;
    Ada.Text_IO.Put(Item => '#');
    Ada.Text_IO.New_Line;
  END PrintList;

  PROCEDURE CopyBack (To: IN OUT List; From: IN List) IS
  -- Pre:  From is defined
  -- Post: copies From to To, starting with the last node of
  --   From and moving forward.
    Current: Position;
  BEGIN
    Initialize(To);
    Current := Last(From);
    WHILE NOT IsPastBegin(From, Current) LOOP
      AddToFront(To, Retrieve(From, Current));
      GoBack(From, Current);
    END LOOP;
  END CopyBack;   

  PROCEDURE Weave (From: IN OUT List) IS
  -- Pre:  From is defined
  -- Post: inserts a character after each node of L
    Current: Position;
  BEGIN
    Current := Last(From);
    WHILE NOT IsPastBegin(From, Current) LOOP
      Insert(From, '%', Current);
      GoBack(From, Current);
    END LOOP;
  END Weave;   

  PROCEDURE Subst (From: IN OUT List) IS
  -- Pre:  From is defined
  -- Post: replaces each character of L by '@'
    Current: Position;
  BEGIN
    Current := Last(From);
    WHILE NOT IsPastBegin(From, Current) LOOP
      Replace(From, '@', Current);
      GoBack(From, Current);
    END LOOP;
  END Subst;   
   
BEGIN -- Test_Lists_Generic
  AddToFront(C1, 'a');
  PrintList(C1);
  AddToFront(C1, 'b');  
  PrintList(C1);
  AddToFront(C1, 'c');  
  PrintList(C1);
  AddToFront(C1, 'd');
  PrintList(C1);
  Copy(To => C2, From => C1);
  PrintList(C2);
  Copy(To => C3, From => C1);
  PrintList(C3);
  FOR Count IN 1..2 LOOP
    Delete(C1, First(C1));
    PrintList(C1);
    Ada.Text_IO.Put(Retrieve(C1, Last(C1)));
    Ada.Text_IO.Put('*');
    Delete(C1, Last(C1));
    PrintList(C1);
  END LOOP;
  FOR Count IN 1..2 LOOP
    Delete(C2, First(C2));
    PrintList(C2);
    Ada.Text_IO.Put(Retrieve(C2, Last(C2)));
    Ada.Text_IO.Put('*');
    Delete(C2, Last(C2));
    PrintList(C2);
  END LOOP;
  AddToFront(C1, 'a');
  PrintList(C1);
  AddToFront(C1, 'b');  
  PrintList(C1);
  AddToFront(C1, 'c');  
  PrintList(C1);
  AddToFront(C1, 'd');
  PrintList(C1);
  Weave(C1);
  PrintList(C1);
  Copy(To => C2, From => C1);
  PrintList(C2);
  Initialize(C1);
  PrintList(C1); 
  CopyBack(To => C1, From => C2);
  PrintList(C1);
  FOR Count IN 1..4 LOOP
    Delete(C1, First(C1));
    PrintList(C1);
    Ada.Text_IO.Put(Retrieve(C1, Last(C1)));
    Ada.Text_IO.Put('*');
    Delete(C1, Last(C1));
    PrintList(C1);
  END LOOP;
  Subst(C2);
  PrintList(C2);
END Test_Lists_Generic;
