WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Numerics.Elementary_Functions;
USE  Ada.Numerics.Elementary_Functions;
PROCEDURE Square_Root_Table IS
------------------------------------------------------------------
--| Displays a table of square roots; illustrates the USE clause
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  MaxNumber : CONSTANT Positive := 20;

BEGIN  -- Square_Root_Table   

  Ada.Text_IO.Put (Item => "Number  Square Root");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put (Item => "------  -----------");
  Ada.Text_IO.New_Line;

  FOR Number IN 1..MaxNumber LOOP
    Ada.Integer_Text_IO.Put (Item => Number, Width => 3);
    Ada.Float_Text_IO.Put 
      (Item => Sqrt (Float(Number)), Fore => 7, Aft => 5, Exp => 0);
    Ada.Text_IO.New_Line;
  END LOOP;

END Square_Root_Table;
