SEPARATE (Singly_Linked_Lists)
PROCEDURE InsertInOrder (L: IN OUT List; Word: IN WordType) IS
------------------------------------------------------------------------
--| Iterative implementation of InsertInOrder
--| if Word already in list, second occurrence must follow first one
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------------

  Current:  ListPtr;  -- designates each node of input list in turn
  Previous: ListPtr;  -- trailer - one node behind Current
  Temp:     ListPtr;  -- holds pointer to newly allocated node

BEGIN -- InsertInOrder

  IF L.Head = NULL THEN                -- case (1)
    AddToFront (L, Word);

  ELSIF Word < L.Head.ALL.Word THEN    -- case (2)
    AddToFront (L, Word);

  ELSIF Word >= L.Tail.ALL.Word THEN   -- case (3)
    AddToEnd (L, Word);

  ELSE                                 -- case (4)

    -- at this point, we know L is not empty and
    -- first word <= Word < last word

    Temp     := NEW ListNode'(Word, NULL);
    Previous := L.Head;             -- first node
    Current  := Previous.ALL.Next;  -- second node, if any

    WHILE Word >= Current.ALL.Word LOOP

      Previous := Current;
      Current  := Current.ALL.Next;

    END LOOP;
    -- assert: Previous.ALL.Word <= Word < Current.ALL.Word

    -- insert new node between Previous and Current
    Temp.ALL.Next := Current;
    Previous.ALL.Next := Temp;

  END IF;

END InsertInOrder;
