WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PACKAGE BODY Rationals.IO IS
------------------------------------------------------------------
--|                                                       
--| Body of the input/output child package for Rationals
--|                                                           
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995          
--|                                                              
------------------------------------------------------------------

  -- input procedures

  PROCEDURE Get (File: IN Ada.Text_IO.File_Type; Item : OUT Rational) IS
  
    N: Integer;
    D: Integer;
    Dummy: Character;  -- dummy character to hold the "/"

  BEGIN -- Get

    Ada.Integer_Text_IO.Get(File => File, Item => N);
    Ada.Text_IO.Get  (File => File, Item => Dummy);
    Ada.Integer_Text_IO.Get(File => File, Item => D);
    Item := N/D;

  END Get;

  PROCEDURE Get (Item : OUT Rational) IS

  BEGIN -- Get

    Get(File => Ada.Text_IO.Standard_Input, Item => Item);

  END Get;

  -- output procedures

  PROCEDURE Put (File: IN Ada.Text_IO.File_Type; Item : IN Rational) IS
  
  BEGIN -- Put

    Ada.Integer_Text_IO.Put(File => File, Item => Numer(Item), Width => 1);
    Ada.Text_IO.Put(File => File, Item => '/');
    Ada.Integer_Text_IO.Put(File => File, Item => Denom(Item), Width => 1);

  END Put;
        
  PROCEDURE Put (Item : IN Rational) IS

  BEGIN -- Put

    Put(File => Ada.Text_IO.Standard_Output, Item => Item);

  END Put;

END Rationals.IO;
