SEPARATE (Digraphs_Generic)
PROCEDURE Traverse_DFS (G: IN Digraph; Start: Vertices) IS
------------------------------------------------------------------------
--| Depth_First_Search, subunit of Digraphs_Generic
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  Visited: VertexSets.Set;

  PROCEDURE DepthFirst (Start: Vertices) IS
  BEGIN
    Visit (Start);
    Visited := Visited + Start;
    FOR Destination IN Vertices LOOP
      IF IsAdjacent (G, Start, Destination) AND NOT 
         IsIn (Visited, Destination) THEN
        DepthFirst (Start => Destination);
      END IF;
    END LOOP;
  END DepthFirst;

BEGIN
  DepthFirst(Start => Start);
END Traverse_DFS;
