WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PACKAGE BODY Currency.IO IS
------------------------------------------------------------------
--|                                                              
--| Body of the input/output child package for Currency
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------

  -- input procedures

  PROCEDURE Get (File: IN Ada.Text_IO.File_Type; Item : OUT Quantity) IS
    F: Float;
  BEGIN -- Get

    -- just read it as a Float quantity, then convert
    Ada.Float_Text_IO.Get(File => File, Item => F);
    Item := MakeCurrency(F);

  END Get;

  PROCEDURE Get (Item : OUT Quantity) IS
  BEGIN -- Get
    Get(File => Ada.Text_IO.Standard_Input, Item => Item);
  END Get;

  -- output procedures

  PROCEDURE Put (File : IN Ada.Text_IO.File_Type;
                 Item : IN Quantity; Width: IN Natural:=8) IS
  BEGIN -- Put

    -- dollars first
    IF IsPositive(Item) THEN
      Ada.Integer_Text_IO.Put(File=>File, Item=>Dollars(Item),Width=>1);
    ELSE
      Ada.Integer_Text_IO.Put(File=>File, Item=>-Dollars(Item),Width=>1);
    END IF;

    -- then decimal point and cents
    Ada.Text_IO.Put(File => File, Item => '.');
    IF Cents(Item) < 10 THEN
      Ada.Text_IO.Put(File => File, Item => '0');
    END IF;
    Ada.Integer_Text_IO.Put(File => File, Item => Cents(Item),Width => 1);

  END Put;

  PROCEDURE Put (Item : IN Quantity; Width: IN Natural:=8) IS
  BEGIN -- Put
    Put(File => Ada.Text_IO.Standard_Output, Item => Item, Width => Width);
  END Put;

END Currency.IO;
