-----------------------------------------------------------------------
--
--  File:        play.adb
--  Description: HANGMAN game playing
--  Rev:         0.2
--  Date:        03/01/97
--  Author:      Jerry van Dijk
--  Mail:        jerry@jvdsys.nextjk.stuyts.nl
--
--  Copyright (c) Jerry van Dijk, 1997
--  Forelstraat 211
--  2037 KV  HAARLEM
--  THE NETHERLANDS
--  tel int + 31 23 540 1052
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
with Display, Letters, Words, Input, Conio.Keys, Gallow, Messages, Sound;
use  Display, Letters, Words, Input, Conio.Keys, Gallow, Messages, Sound;

package body Play is

   Number_Guessed    : Natural := 0;
   Number_Of_Games   : Natural := 0;

   procedure Play_Game (Again : out Boolean) is
      C                 : Character;
      Guess_Word        : Word := Pick_A_Word;
      Status            : Gallow_Status := None;
      Available_Letters : Letter_Set := Default_Letter_Set;
   begin
      Prepare_Display;
      Show_Gallow;
      Display_Statistics (Number_Of_Games, Number_Guessed,
                          Number_Of_Words, Number_Words_Used);
      while not Is_Word_Guessed (Guess_Word) and Status /= Lower_Right loop
         Show (Available_Letters);
         Show (Guess_Word);
         C := Get_Guess;
         if C = K_Escape then
            Again := False;
            exit;
         elsif Is_Valid (Available_Letters, C) then
            Set_Used(Available_Letters, C);
            If Is_In_Word (Guess_Word, C) then
               Set_Guessed (Guess_Word, C);
            else
               Status := Gallow_Status'Succ (Status);
               Display_Body (Status);
               Sad_Sound;
            end if;
         else
            Dentist_Sound;
         end if;
      end loop;
      if C /= K_Escape then
         Vague_Sound;
         Used_Words (Guess_Word);
         Number_Of_Games := Number_Of_Games + 1;
         if Status = Lower_Right then
            Forced_Word_Guessed (Guess_Word);
            Show (Guess_Word);
            Lost_Message;
         else
            Number_Guessed := Number_Guessed + 1;
            Show (Guess_Word);
            Won_Message;
         end if;
         Again := Ask_Next;
      end if;
   end Play_Game;

end Play;
