-- This is class definition for an integer ring implemented as
-- an array.  The size of a new ring can be defined by user or set
-- to default SIZE.

--Sasa Tomic	Sept. 95

with EASY_IO;  

package Demo4 is
    type Integer_Ring is private;
    procedure  Insert_An_Object(r: IN OUT Integer_Ring; myData: IN integer);
    function   Current_Object(r: IN Integer_Ring) return integer;
    procedure  Change_Current_Object(r: IN OUT Integer_Ring; myData: IN integer);
    procedure  Delete_Current_Object(r: IN OUT Integer_Ring);
    function   Number_Of_Objects(r: IN Integer_Ring) return integer;
    procedure  Move_Cursor_Forward(r: IN OUT Integer_Ring);
    procedure  Move_Cursor_Backward(r: IN OUT Integer_Ring);

-- exceptions
ring_full	:exception;
ring_empty	:exception;
private
    type RingData;
    type Link is access RingData;
    type RingData is record
	value:	integer;
	next:	link;
	prev:	link;
    end record; 
    type Integer_Ring is record
	current: link;
	theSize: integer;
	maxSize: integer := 1000;
    end record;
end Demo4;
 
