#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#include <signal.h>
#endif

#ifdef PDCDEBUG
char *rcsid__sysgetc = "$Header: C:\CURSES\private\RCS\_sysgetc.c 2.1 1993/06/18 20:22:44 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_sysgetch()	- Return a character using default system routines.

  PDCurses Description:
 	This is a private PDCurses function.

 	Gets a character without normal ^S, ^Q, ^P and ^C interpretation
 	and returns it.  If keypad mode is active for the designated
 	window, function key translation will be performed. Otherwise,
 	function keys are ignored. If nodelay mode is active in the
 	window, then sysgetch() returns -1 if no character is
 	available.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	No errors are defined for this routine.

  Portability:
 	PDCurses	int	PDC_sysgetch( void );

**man-end**********************************************************************/

#ifdef UNIX
static bool alarmed;
#endif

int	PDC_sysgetch(void)
{
extern	WINDOW*	_getch_win_;
/* extern	WINDOW*	w;*/   /* w defined in wgetch() as static - _getch_win_ */
                        /* is the same window - all references to w changed*/
                        /* to _getch_win_ - marked with @@ */

	signed int c;

#ifdef UNIX
	void (*oldsig)();
	void sigalrm();
	char keybuf[10];
	char *bufp=keybuf;
	int val;
	register int i=0;
#define MATCH_FALSE 0
#define MATCH_PARTIAL 1
#define MATCH_TRUE 2
	char match;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_sysgetch() - called\n");
#endif

	if (_getch_win_ == (WINDOW *)NULL)  /* @@ */
		return (-1);

#ifdef UNIX
/* INCOMPLETE */
	oldsig = signal(SIGALRM,sigalrm);
	alarmed = FALSE;
	while(1)
		{
		c = getchar();
		if (c != EOF)
			{
			*(bufp+i++) = c;
			*(bufp+i) = '\0';
			}
		if (alarmed)
			break;
		val = find_key(keybuf,i);
		if (val == MATCH_FALSE)
			{
			alarm(0);
			signal(SIGALRM,oldsig);
			return(keybuf[0]);
			}
		if (val != MATCH_PARTIAL)
			{
			alarm(0);
			signal(SIGALRM,oldsig);
			return(val);
			}
		alarm(1);
		}
	alarm(0);
	signal(SIGALRM,oldsig);
/* INCOMPLETE */
	return(c);
#else
	while (1)
	{
		c = PDC_get_bios_key();
#if	defined (DOS) || defined (OS2)
		/*
		 * Return the key if it is not a special key.
		 */
		if (c & A_CHARTEXT)
			return (c & A_CHARTEXT);
#endif
		if ((c = PDC_validchar(c)) >= 0)
		{
			return (c);		/* get & check next char */
		}
	}
#endif
}
#ifdef UNIX
static void sigalrm()
{
	alarmed = TRUE;
	signal(SIGALRM,sigalrm);
}
static int find_key(char *seq,int len)
{
	register int i;

	for (i=0;i<_cursvar.number_keys;i++)
		{
		if (strcmp(seq,_cursvar.key_seq[i]) == 0)
			return(_cursvar.key_num[i]);
		if (memcmp(seq,_cursvar.key_seq[i],len) == 0)
			return(MATCH_PARTIAL);
		}
	return(MATCH_FALSE);
}
#endif
