#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wmove

#ifdef PDCDEBUG
char *rcsid_wmove = "$Header: C:\CURSES\portable\RCS\wmove.c 2.1 1993/06/18 20:21:45 MH Rel MH $";
#endif




/*man-start*********************************************************************

  wmove()	- Move cursor in window

  X/Open Description:
 	The cursor associated with the window is moved to the given
 	location.  This does not move the physical cursor of the
 	terminal until refresh() is called.  The position specified is
 	relative to the upper left corner of the window, which is (0,0).

 	NOTE: move() is a macro.

  PDCurses Description:
 	There may be additional [window oriented] move routines associated
 	with other sections of the curses library.  See those sections for
 	details.

  X/Open Return Value:
 	These functions return OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wmove( WINDOW* win, int y, int x );
 	X/Open Dec '88	int wmove( WINDOW* win, int y, int x );
 	BSD Curses	int wmove( WINDOW* win, int y, int x );
 	SYS V Curses	int wmove( WINDOW* win, int y, int x );

**man-end**********************************************************************/

int	wmove(WINDOW *win, int y, int x)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wmove() - called: y=%d x=%d\n",y,x);
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	if ((x < 0) ||
	    (y < 0) ||
	    (x >= win->_maxx) ||
	    (y >= win->_maxy) ||
	    (y < win->_tmarg) ||
	    (y > win->_bmarg))
	{
		return( ERR );
	}
	win->_curx = x;
	win->_cury = y;
	return( OK );
}
