#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	waddstr

#ifdef PDCDEBUG
char *rcsid_waddstr = "$Header: C:\CURSES\portable\RCS\waddstr.c 2.1 1993/06/18 20:21:28 MH Rel MH $";
#endif




/*man-start*********************************************************************

  waddstr()	- add string to window

  X/Open Description:
 	These routines write all the characters of the null-terminated
 	string str on the given window.  The functionality is equivalent
 	to calling waddch() once for each character in the string.

 	NOTE:  addstr(), mvaddstr(), and mvwaddstr() are macros.

  PDCurses Description:
 	The *raw*() routines output 8 bit values.  These contrast to their
 	normal counterparts which output 7 bit values and convert control
 	character to the ^X notation.

 	str is a standard 8 bit character string WITHOUT embedded attributes.

  X/Open Return Value:
 	The waddstr() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int waddstr( WINDOW* win, char* str );
 	X/Open Dec '88	int waddstr( WINDOW* win, char* str );
 	BSD Curses	int waddstr( WINDOW* win, char* str );
 	SYS V Curses	int waddstr( WINDOW* win, char* str );

**man-end**********************************************************************/

int	waddstr(WINDOW *win, char *str)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("waddtsr() - called: string=\"%s\"\n",str);
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	while (*str)
	{
		if (waddch(win, *str++) == ERR)
		{
			return( ERR );
		}
	}
	return( OK );
}
