#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef	nocbreak

#ifdef PDCDEBUG
char *rcsid_nocbreak = "$Header: C:\CURSES\portable\RCS\nocbreak.c 2.1 1993/06/18 20:20:35 MH Rel MH $";
#endif




/*man-start*********************************************************************

  nocbreak()	- set/clear cbreak mode

  X/Open Description:	cbreak() and nocbreak()
 	These two routines put the terminal into and out of cbreak mode.
 	In cbreak mode, characters typed by the user are immediately
 	available to the program and erase/kill character processing is
 	not performed.  When out of cbreak mode, the terminal driver
 	will buffer characters typed until a newline or carriage return
 	is typed.  Interrupt and flow control characters are unaffected
 	by this mode.  Initially the terminal may or may not need be
 	in cbreak mode.

  PDCurses Description:
 	There is no additional PDCurses functionality.

  X/Open Return Value:
 	The nocbreak() function returns OK on success and ERR on error.

  PDCurses Errors:
 	No errors are defined for these functions.

  Portability:
 	PDCurses	int nocbreak( void );
 	X/Open Dec '88	int nocbreak( void );
 	BSD Curses	int nocbreak( void );
 	SYS V Curses	int nocbreak( void );

**man-end**********************************************************************/

int	nocbreak(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("nocbreak() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	_CUR_TERM.prog_mode.c_lflag |= ICANON;
	ioctl(_CUR_TERM.fd, TCSETAW, &_CUR_TERM.prog_mode);
#else 
	_CUR_TERM->prog_mode.sg_flags &= ~CBREAK;
	ioctl(_CUR_TERM.fd, TIOCSETP,&_CUR_TERM.prog_mode);
#endif
#endif

	_cursvar.cbreak = FALSE;
	return( OK );
}
