NAME
     dd - convert a file while copying it

SYNOPSIS
     dd [if=file] [of=file] [ibs=bytes] [obs=bytes] [bs=bytes]
     [cbs=bytes] [skip=blocks] [seek=blocks] [count=blocks]
     [conv={ascii,ebcdic,ibm,block,unblock,lcase,ucase,swab,noerror,notrunc,
     sync}]

DESCRIPTION
     This manual page documents the GNU version of dd.  dd copies
     a file (from the standard input to the standard output, by
     default) with a user-selectable blocksize, while optionally
     performing conversions on it.

     OPTIONS
     Numbers can be followed by a multiplier:
     b=512, k=1024, w=2, xm=number m

     if=file
          Read from file instead of the standard input.

     of=file
          Write to file instead of the standard output.  Unless
          conv=notrunc is given, truncate file to the size speci-
          fied by seek= (0 bytes if seek= is not given).

     ibs=bytes
          Read bytes bytes at a time.

     obs=bytes
          Write bytes bytes at a time.

     bs=bytes
          Read and write bytes bytes at atime.  Override ibs and
          obs.

     cbs=bytes
          Convert bytes bytes at a time.

     skip=blocks
          Skip blocks ibs-sized blocks at start of input.

     seek=blocks
          Skip blocks obs-sized blocks at start of output.

     count=blocks
          Copy only blocks ibs-sized input blocks.

     conv=conversion[,conversion...]
          Convert the file as specified by the conversion argu-
          ments.
          Conversions:

          ascii
            Convert EBCDIC to ASCII.

          ebcdic
            Convert ASCII to EBCDIC.

          ibm
            Convert ASCII to alternate EBCDIC.

          block
            Pad newline-terminated records to size of cbs,
            replacing newline with trailing spaces.

          unblock
            Replace trailing spaces in cbs-sized block with new-
            line.

          lcase
            Change uppercase characters to lowercase.

          ucase
            Change lowercase characters to uppercase.

          swab
            Swap every pair of input bytes.  Unlike the Unix dd,
            this works when an odd number of bytes are read.  If
            the input file contains an odd number of bytes, the
            last byte is simply copied (since there is nothing to
            swap it with).

          noerror
            Continue after read errors.

          sync
            Pad every input block to size of ibs with trailing
            NULs.
