/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Screen graphics management
	File      : Include/Graphics/Grx.H
	Author    : Eric NICOLAS
	Overview  : Includes LibGrx headers, depending on version
	UpDate    : Feb 20, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_GRX_H_
#define _GRAPHICS_GRX_H_

#ifdef _GRX20_
  // Include necessary stuff for GRX20
  #include "graphics/grx20/grx20.h"
#else
  // Include necessary stuff for GRX V1.03
  #include "graphics/grx/grx.h"
  #include "graphics/grx/mousex.h"
  // Make some definitions for consistency between GRX1 and GRX20
  #define GR_M_MOTION          M_MOTION
  #define GR_M_LEFT_DOWN       M_LEFT_DOWN
  #define GR_M_LEFT_UP         M_LEFT_UP
  #define GR_M_RIGHT_DOWN      M_RIGHT_DOWN
  #define GR_M_RIGHT_UP        M_RIGHT_UP
  #define GR_M_KEYPRESS        M_KEYPRESS
  #define GR_M_POLL            M_POLL
  #define GR_M_EVENT           M_EVENT
  #define GR_M_NOPAINT         M_NOPAINT
  #define GR_M_CUR_BOX         M_CUR_BOX
  #define GR_M_CUR_NORMAL      M_CUR_NORMAL
  #define GR_M_CUR_RUBBER      M_CUR_RUBBER

  #define GrMouseEvent         MouseEvent
  #define GrMouseGetEvent      MouseGetEvent
  #define GrMouseGetCursor     MouseGetCursor
  #define GrMouseSetCursor     MouseSetCursor
  #define GrMouseEraseCursor   MouseEraseCursor
  #define GrMouseDisplayCursor MouseDisplayCursor
  #define GrMouseWarp          MouseWarp
  #define GrMouseSetCursorMode MouseSetCursorMode
  #define GrMouseDetect        MouseDetect
  #define GrMouseEventMode     MouseEventMode
  #define GrMouseEventEnable   MouseEventEnable
  #define GrMouseInit          MouseInit
  #define GrMouseUnInit        MouseUnInit
  #define GrMouseSetLimits     MouseSetLimits
  #define GrMouseBlock         MouseBlock
  #define GrMouseUnBlock       MouseUnBlock

  #define xcord                cr_xcord
  #define ycord                cr_ycord
#endif

#endif // _GRAPHICS_GRX_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: Moving this code from graphics.h to grx.h
**   10/04/96 :EN: Shipping grx includes with SWORD package
** ------------------------------------------------------------------------*/
