/*             Source file for DJGPP Window System. VESA routines.
               ===================================================

               Copyright (c) 1994 Grafik Software by Malcolm Taylor
*/

#ifndef _vesa_h
#define _vesa_h

#include <types.h>


typedef struct {
   WORD mode;                    /* The current mode, >32768 is mode X */
   WORD scan_length;             /* Width in bytes of each scanline */
   WORD width,height;            /* Width and height of screen area */
   WORD aspect;                  /* Aspect ratio (y/x)/1.33333*256 */
   WORD col_depth;               /* The colour depth of the current mode in bits */
} VIDEO_DATA;

extern VIDEO_DATA VideoData;  /* The data about the current video mode */
extern int VESApage;

#ifdef __cplusplus
extern "C" {
#endif

int VESASetMode(int mode);       /* Sets up vesa video mode. */
int XSetMode(int mode);          /* Sets up mode X video mode */
int QSetMode(int mode);          /* Setup the mode X mode */
int VGASetMode(int mode);        /* Setup normal VGA modes */
void DeinitGraphics(void);       /* Returns to Text mode. */
void VESABitBlt(void *from,int scan_length,int x,int y,int width,int height);
                              /* BitBlt a block width*height with scan_length 
                                    from memory to screen at pos x,y */
void XBitBlt(void *from,int scan_length,int x,int y,int width,int height);
                              /* BitBlt a block width*height with scan_length 
                                    from memory to screen at pos x,y */
void QBitBlt(void *from,int scan_length,int x,int y,int width,int height);
                              /* BitBlt a block width*height with scan_length 
                                    from memory to screen at pos x,y */
void VESASetPage(int page);
void Set8BitColour(int n,int r,int g,int b);
                                 /* Sets a palette register */

#ifdef __cplusplus
}
#endif

#endif
