/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> COMPRESS.H
 -> Declarations for compression routines.
*/

#ifndef _compress_h
#define _compress_h

#include <types.h>
#include <stdio.h>


#ifdef __cplusplus
extern "C" {
#endif

#define SUPER_FAST_COMPRESSION_MODE 0
#define FAST_COMPRESSION_MODE       1
#define NORMAL_COMPRESSION_MODE     2
#define MAXIMUM_COMPRESSION_MODE    3

void SetCompressionMode(int mode);
									/* Sets the compression mode used to fast,
										normal or maximum compression. */

BYTE *CompressMemory(BYTE *memory,int length,int *newlength);
									/* Compresses a block of memory giving 
										the new length in newlength and method 
										in flags. Returns NULL for store */
BYTE *DecompressMemory(BYTE *memory,int length,int *newlength);
									/* Decompresses a block of memory giving
										the new length in newlength with method 
										in flags */


#ifdef __cplusplus
}
#endif



#endif
