/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcstod.c,v 1.1 1996/07/13 20:39:38 jack Exp $ */

#include <wchar.h>
#include <wctype.h>

#define WC(c) ((wchar_t) (c))

static long double powtbl[] =
{
  1e1L, 1e2L, 1e4L, 1e8L, 1e16L, 1e32L, 1e64L, 1e128L, 1e256L,
};

double
wcstod (const wchar_t *ws, wchar_t **endptr)
{
  const wchar_t *save;
  long double value = 0.0L;
  int exp = 0;
  int sign = 0, esign = 0;
  wchar_t wc;

  /* skip white space */
  while ((wc = *ws++))
    if (! iswspace (wc))
      break;

  /* get sign */
  switch (wc)
    {
    case WC ('-'):
      sign = -1;
    case WC ('+'):
      wc = *ws++;
    }

  /* get integer */
  for (save = ws; wc >= WC ('0') && wc <= WC ('9'); wc = *ws++)
    {
      value *= 10.0L;
      value += (long double) (wc - WC ('0'));
    }

  /* get decimal */
  if (wc == WC ('.'))
    {
      long double d = 0.1L;

      wc = *ws++;
      for (save = ws; wc >= WC ('0') && wc <= WC ('9'); wc = *ws++)
	{
	  d *= 0.1L;
	  value += d * (long double) (wc - WC ('0'));
	}
    }

  if (save == ws)
    {
    convert_error:
      if (endptr != NULL)
	*endptr = (wchar_t *) ws - 1;
      return 0.0;
    }

  /* is lead exponent ? */
  if ((wc == WC ('e')) || (wc == WC ('E')))
    {
      wc = *ws++;

      /* get exponent's sign */
      switch (wc)
	{
	case WC ('-'):
	  esign = -1;
	case WC ('+'):
	  wc = *ws++;
	}

      /* get exponent value */
      for (; wc >= WC ('0') && wc <= WC ('9'); wc = *ws++)
	{
	  exp *= 10;
	  exp += wc - WC ('0');
	}
    }

  /* reflect exponent */
  if (exp != 0)
    {
      long double e;
      int shifts;

      if (((sign < 0) && (exp > 324)) || ((sign >= 0) && (exp > 308)))
	goto convert_error;

      for (e = 1.0L, shifts = 0; exp != 0; exp >>= 1, shifts++)
	if (exp & 1)
	  e *= powtbl[shifts];

      if (esign < 0)
	value /= e;
      else
	value *= e;
    }

  if (endptr != NULL)
    *endptr = (wchar_t *) ws - 1;

  return (double) ((sign < 0 && value != 0.0L) ? -value : value);
}
