/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbsnextc.c,v 1.1 1996/06/30 13:25:00 jack Exp $ */

#include <mbctype.h>
#include <mbstring.h>

int
_mbsnextc (const unsigned char *us)
{
  /* return 1 or 2 characters */
  if (_ismbblead (us[0]) && us[1] != '\0')
    return (int) ((us[0] << 8) + us[1]);

  /* single character */
  return (int) us[0];
}
