/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbtowc.c,v 1.3 1996/07/09 18:20:15 jack Exp $ */

#include <stdlib.h>
#include <mbctype.h>
#include <mbprvt.h>

int
mbtowc (wchar_t *pwc, const char *s, size_t n)
{
  wchar_t wc;

  /* Shift-JIS is not state-dependent encoding */
  if (s == 0)
    return 0;

  /* EOS or invalid size */
  if (s[0] == '\0' || n <= 0)
    return 0;

  /* return 1 if s[0] is single byte */
  if (! _ismbblead (s[0]))
    {
      if (pwc != 0)
	{
	  /* convert to wchar */
	  wc = __string_single_to_wchar (s);

	  /* replace an error with a valid character */
	  if (wc == _MBC_ERROR_WCHAR)
	    wc = (wchar_t) (unsigned char) _MBC_REPLACE_SINGLE;

	  /* set to buffer */
	  *pwc = wc;
	}
      return 1;
    }

  /* Shift-JIS always have two bytes for multibyte charcter */
  if (n >= 2 && s[1] != '\0' && _ismbbtrail (s[1]))
    {
      if (pwc != 0)
	{
	  /* convert to wchar */
	  wc = __string_double_to_wchar (s);

	  /* replace an error with a valid character */
	  if (wc == _MBC_ERROR_WCHAR)
	    wc = _MBC_REPLACE_WCHAR;

	  /* set to buffer */
	  *pwc = wc;
	}
      return 2;
    }

  /* invalid multibyte character */
  return -1;
}
