// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef DitherViewportPrivateClass
#define DitherViewportPrivateClass

// This is a private include file.  You shouldn't include it unless
// you are defining a new dithered Viewport, such as in the case of
// Viewport8BppSubPixel.C.

// The full interface to all Viewports is available through Viewport.H.
// You do not need to know about a particular subclass of Viewport in
// order to use it - the exemplar mechanism takes care of all that.


#include <Lib3d/Viewport.H>

class DitherViewport : public Viewport
{
public:
    void lineZb(const DeviceVector &, const DeviceVector &, DeviceColour);
    void flatPolygonZb(uint, PipelineData *const[], Colour  );
    void flatTriangleZb(PipelineData *const[], Colour );
    void smoothPolygonZb(uint, SmoothPipelineData *const[], const ColourRamp& );
    void smoothTriangleZb(SmoothPipelineData *const[], const ColourRamp& );

    Colour getColour( uint r, uint g, uint b );

    void drawColourSpace();
    const char *getName() const { return "DitherViewport"; }

protected:
    Viewport *clone( Device *device );
    ~DitherViewport();
    DitherViewport( Exemplar e, int speed = 80 );
    DitherViewport( Device *, uint = 1, uint = 1 );
    virtual void initializeColours();

protected:
    uchar *ditherTable;
    uchar colourTable[256];

private:
    static DitherViewport *advertisment;
};




#endif

