#ifndef PipelineClass 
#define PipelineClass

#include <Lib3d/internals/Debuggable.H>
#include <Lib3d/internals/types.H>

struct Polygon;
struct Vertex;
struct Normal;
struct Material;
class Matrix4;
class Matrix34;
class Vector3;
class Model;
class Viewport;
class Light;
class Texture;

class Pipeline : public Debuggable
{
public:
    Pipeline() {}
    virtual ~Pipeline() {}

    const char *getName() const { return "Pipeline"; }

    virtual void registerModel( Model &) = 0;
    virtual void render(Model &, Viewport &, const Light *, uint nr,
			uint clipPlanes, uint flags ) = 0;

protected:
    void stitchModel(  Model & );

protected:
    uint nrPolygons;
    uint nrVertices;
    uint nrVertexNormals;
    uint nrPolygonNormals;
    uint nrMaterials;
    const Polygon  *polygons;
    const Vertex   *vertices;
    const Normal   *vertexNormals;
    const Normal   *polygonNormals;
    Material *materials;
    Texture *texture;

    const Matrix4  *objectToDevice;
    const Vector3  *objectViewPos;
    const Matrix34 *objectToCvv_T;
    const Matrix34 *objectToCvv;
    const Matrix4  *cvvToDevice;
    float D;
};


#endif
