#include <Lib3d/Viewport.H>
#include <Lib3d/Model.H>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <Lib3d/Light.H>
#include <Lib3d/internals/HrTimer.H>
#include <iostream.h>
#include <fstream.h>


main()
{
    Viewport *viewport = Viewport::create(Device::create(320, 200, 8));
    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }

    cout << *viewport << endl;

    World world;
    ModelBuilder ob;

    ifstream in("../models/teapot.nff");
    if (in.bad()) {
	cerr << "Couldn't open teapot.nff" << endl;
	exit(-1);
    }

    ob.startModel();
    // ob.setColourfulMode();	// Beachball mode
    ob.readNFF( in );

    Model *model = ob.endModel();
    world.adopt(model);

    cout << "Created object:\n" << *model << endl;

    Camera *camera = new Camera(world);
    camera->setParameters(3,100,15,1);

    world.setActiveCamera( *camera );


    Vector3 colour(1,1,1);	// A white light
    Vector3 direction(0,1,.5);
    Light *light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );


    Matrix34 mod;		// Model transform.
    Matrix34 cam;		// Accumulated camera transform.
    Matrix34 cameraRot;		// Iteration for camera transform.

    cout << "Camera positioned at origin, teapot at (0,-1,20),\n"
   	    "camera rotating on the spot." << endl;

    mod.setTranslation(0,-1,20);
    cam.setIdentity();
    cameraRot.setRotation( 3, 0, 1, 0 ); 

    model->setTransform(mod);	

    for ( int i = 0 ; i < 1200 ; i++ ) {
        cam.premul( cameraRot );
        camera->setTransform( cam );
	world.renderHierarchy( *viewport );
	viewport->swapBuffers();
    }


    cout << "Teapot positioned at origin, camera at (0,-1,-20),\n"
   	    "camera rotating on the spot." << endl;

    mod.setIdentity();
    cam.setTranslation(0,-1,-20);
    cameraRot.setRotation( 3, 0, 1, 0 ); 

    model->setTransform(mod);	

    for ( int i = 0 ; i < 1200 ; i++ ) {
        
	cam.postmul( cameraRot );
        camera->setTransform( cam );

	world.renderHierarchy( *viewport );
	viewport->swapBuffers();
    }

    cout << "Teapot positioned at origin, camera at (0,-1,-20),\n"
   	    "camera rotating about the origin." << endl;

    mod.setIdentity();
    cam.setTranslation(0,-1,-20);
    cameraRot.setRotation( 3, 0, 1, 0 ); 

    model->setTransform(mod);	

    for ( int i = 0 ; i < 1200 ; i++ ) {
	cam.premul(cameraRot);
        camera->setTransform( cam );
	world.renderHierarchy( *viewport );
	viewport->swapBuffers();
    }

    delete viewport;
}










