/****************************************************************************/
/* TMENUBAR                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TMenuBar (barre de menus)                                          */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 20/07/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdlib.h>
#include <values.h>

#include "Const.h"
#include "JPDebug.h"

#include "JPAppli.h"
#include "Cursor.h"
#include "Errors.h"
#include "Mouse.h"
#include "Screen.h"
#include "Strings.h"

#include "TMenu.h"
#include "TWindow.h"

#include "TMenuBar.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* window           : Fentre  laquelle appartient l'objet                 */
/****************************************************************************/

TMenuBar::TMenuBar(PWindow window)
         :TObject(window,
		 OBJ_MENU_BAR,
	         0,
		 ((window->m_get_caption())[0]==0)?0:1,
                 window->m_get_width(),1,
	         WHITE,
                 "",
                 ENABLED,
		 false,  // NOT_FOCUS_DEPENDING_ASPECT
		 true,   // CAN_BE_ENABLED,
		 true)   // SIMPLE
{
  // Menus de l'objet

  f_nb_menus=0;
  f_menu_list=NULL;
  f_last_menu=NULL;

  // La barre de menu n'est pas en cours d'utilisation

  f_active=false;

  // Menu actif

  f_active_menu=NULL;

  // Le curseur tait actif lors de l'ouverture du menu

  f_cursor_was_visible=false;

  // Message d'info de la fenetre avant d'ouvrir le menu */

  f_window_info_message=NULL;

  // Couleur du titre de la fentre

  f_window->m_set_title_attr((LIGHTBLUE<<4)+(unsigned)WHITE);
}

/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TMenuBar::~TMenuBar()
{
  PMenuNode node,next_node;

  // Destruction des variables dynamiques

  if (f_window_info_message!=NULL)
  {
    delete []f_window_info_message;
    f_window_info_message=NULL;
  }

  node=f_menu_list;
  while (node!=NULL)
    {
      next_node=node->next;
      delete node;
      node=next_node;
    }
  f_menu_list=NULL;
}

/****************************************************************************/
/* m_enable                                                                 */
/*--------------------------------------------------------------------------*/
/* Rend l'objet activable                                                   */
/****************************************************************************/

void TMenuBar::m_enable()
{
  PMenuNode node=f_menu_list;

  while (node!=NULL)
   {
     node->menu->m_enable();
     node=node->next;
   }
}

/****************************************************************************/
/* m_disable                                                                */
/*--------------------------------------------------------------------------*/
/* Rend l'objet inactivable                                                 */
/****************************************************************************/

void TMenuBar::m_disable()
{
  PMenuNode node=f_menu_list;

  while (node!=NULL)
   {
     node->menu->m_disable();
     node=node->next;
   }
}


/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/


/****************************************************************************/
/* m_add_menu                                                               */
/*--------------------------------------------------------------------------*/
/* Ajout un menu  la barre et retourne le numro qui lui est attribu      */
/****************************************************************************/

int TMenuBar::m_add_menu(PMenu menu)
{
  PMenuNode new_node;

  // La barre ne doit pas tre ouverte

  JPDEBUG_TEST(DEBUG_ERROR_12,!f_open);

  f_nb_menus++;

  new_node=new TMenuNode;
  new_node->menu=menu;
  new_node->next=NULL;

  if (f_menu_list==NULL)
    f_menu_list=new_node;
  else
    f_last_menu->next=new_node;

  f_last_menu=new_node;

  return (f_nb_menus);
};

/****************************************************************************/
/* m_display                                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

void TMenuBar::m_display()
{
  register int i;
  int rel_y;
  int rel_x1,rel_x2;

  if (!f_open)
    return;

  rel_y=m_get_y_in_window();

  for (i=1;i<=f_nb_menus;i++)
    m_display_menu_caption(i);

  f_window->m_textattr((WHITE<<4)+(unsigned)BLACK);
  f_window->m_gotoxy(0,rel_y);
  f_window->m_putch(' ');

  m_get_menu_caption_pos(f_nb_menus,rel_x1,rel_x2);
  f_window->m_gotoxy(rel_x2+1,rel_y);
  f_window->m_putnch(f_width-rel_x2-1,' ');

}

/*********************************************/
/* m_set_open : Ouvre/Ferme l'objet          */
/* ----------   (ne modifie pas l'affichage) */
/*********************************************/

void TMenuBar::m_set_open(bool open)
{
  if (!open)
    m_close_menu();

  TObject::m_set_open(open);
  f_window->m_set_short_cut_handler(f_open?this:NULL);
}


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne true si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

bool TMenuBar::m_left_button_pressed_event(int x,int y)
{
  PMenu menu=NULL;
  int  selected_item=0;

  int button_state;
  register int i;
  int  last_menu_selected;
  int  open_menu;

  int  rel_x1,rel_x2;
  int  x1_menu,x2_menu,y1_menu,y2_menu;
  int  x1_list,x2_list,y1_list,y2_list;

  bool stayed_in_open_menu_title;

  bool found;

  int  x1=m_get_x();
  int  x2=x1+f_width-1;
  int  y1=m_get_y();

  // Rmq : la barre n'a pas le focus ici


  button_state=LEFT_BUTTON_PRESSED;
  last_menu_selected=0;

  if (f_active_menu!=NULL)
    {
      open_menu=f_active_menu->f_menu_nb;
      x1_list=f_active_menu->m_get_x_list();
      x2_list=x1_list+f_active_menu->m_get_list_width()-1;
      y1_list=f_active_menu->m_get_y_list();
      y2_list=y1_list+f_active_menu->m_get_list_height()-1;
      if (   (x<x1_list) || (x>x2_list)
	  || (y<y1_list) || (y>y2_list))
	{
	  f_active_menu->m_set_selected_item_index(0);
	  JPRefresh();
	}
      stayed_in_open_menu_title=true;
    }
  else
    {
      open_menu=0;
      stayed_in_open_menu_title=false;
    }

  while (button_state==LEFT_BUTTON_PRESSED)
    {
      // A-t-on cliqu sur un titre de menu

      if ((y==y1) && (x>=x1) && (x<=x2))
	{
	  i=f_nb_menus;
	  found=false;
	  while ((i>=1) && (!found))
	    {
	      m_get_menu_caption_pos(i,rel_x1,rel_x2);
	      if ((x>=(x1+rel_x1)) && (x<=(x1+rel_x2)))
		found=true;
	      else
		i--;
	    }

	  if (found)
	    {
	      if (i!=open_menu)
		stayed_in_open_menu_title=false;

	      if ((i!=last_menu_selected) && (i!=open_menu))
		{
		  if (m_open_menu(i,false))
		    {
		      open_menu=i;
		      JPRefresh();
		    }
		}
	      last_menu_selected=i;
	    }
	  else
	    stayed_in_open_menu_title=false;
	}

      // Clic dans le menu ouvert

      else
	{
	  stayed_in_open_menu_title=false;

	  if (f_active_menu!=NULL)
	    {
	      x1_menu=f_active_menu->m_get_x();
	      x2_menu=x1_menu+f_active_menu->f_width-1;
	      y1_menu=f_active_menu->m_get_y();
	      y2_menu=y1_menu + f_active_menu->f_height-1;


	      if (   (x >= x1_menu)
		  && (x <= x2_menu)
		  && (y >= y1_menu)
		  && (y <= y2_menu))
		f_active_menu->m_left_button_pressed_event(x,y);
	    }

	}
      GetMouseState(x,y,button_state);
    }

  if ((f_active_menu!=NULL) && (!stayed_in_open_menu_title))
    {
      m_get_menu_caption_pos(f_active_menu->f_menu_nb,rel_x1,rel_x2);
      if ( (y==y1) && (x>=(x1+rel_x1)) && (x<=(x1+rel_x2)))
	{
          f_active_menu->m_select_first_possible_item();
          return true;
        }
      selected_item=f_active_menu->f_selected_item_index;
      menu=f_active_menu;
    }

  m_inactivate_menu_bar();

  if (selected_item!=0)
    menu->m_item_clicked_callback(selected_item);

  return true;
}


/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable) */
/*                       Retourne true si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

bool TMenuBar::m_key_pressed_event(TKey key)
{
  PMenuNode node;
  PMenu menu;

  int active_menu_nb;
  bool success;

  int selected_item;

  register int i;
  bool found;

  // Si un menu est dj ouvert

  if (f_active_menu!=NULL)
    {
      active_menu_nb=f_active_menu->f_menu_nb;

      // On regarde si c'est une touche de dplacement entre les menus

      switch (key.character)
	{
	  case LEFT   : success=false;
			do
			  {
			    active_menu_nb--;
			    if (active_menu_nb==0)
			      active_menu_nb=f_nb_menus;
			    success=m_open_menu(active_menu_nb,true);
			  }
			while
			  (!success);

			return true;

	  case RIGHT  : success=false;
			do
			  {
			    active_menu_nb++;
			    if (active_menu_nb>f_nb_menus)
			      active_menu_nb=1;
			    success=m_open_menu(active_menu_nb,true);
			  }
			while
			  (!success);

			return true;

	  case RETURN : if (f_active_menu!=NULL)
			  selected_item=f_active_menu->f_selected_item_index;
			else
			  selected_item=0;

			menu=f_active_menu;
			m_inactivate_menu_bar();

			if (selected_item!=0)
			   menu->m_item_clicked_callback(selected_item);

			return true;

	  case ESC    : m_inactivate_menu_bar();
			return true;
	}

      // Sinon, on passe la touche au menu

      if (m_key_pressed_event_on(f_active_menu,key))
	return true;
    }

  // On regarde si c'est la hot-key du groupe
  // d'un des menus

  i=1;
  node=f_menu_list;
  found=false;

  while ((node!=NULL) && (!found))
    {
      menu=node->menu;
      if (key.hot_character==menu->f_hot_key)
	found=true;
      else
	{
	  i++;
	  node=node->next;
	}
    }

  if (found)
    {
      if (m_open_menu(i,true))
	return true;
    }

  return false;
}

/****************************************************************************/
/* m_short_cut_pressed_event                                                */
/*--------------------------------------------------------------------------*/
/* Appele quand l'objet gre les acclrateurs de sa fentre.              */
/* Retourne true si l'acclrateur intresse l'objet                        */
/****************************************************************************/

bool TMenuBar::m_short_cut_pressed_event(int short_cut)
{
  PMenuNode node=f_menu_list;

  while (node!=NULL)
   {
     if (node->menu->m_short_cut_pressed_event(short_cut))
       return true;
     node=node->next;
   }

  return false;
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/


/****************************************************************************/
/* m_display_menu_caption                                                   */
/*--------------------------------------------------------------------------*/
/* Affiche le titre d'un menu                                               */
/****************************************************************************/

void TMenuBar::m_display_menu_caption(int menu_nb)
{
  int selected_menu_nb=0;
  PMenu menu;
  char *caption;
  int rel_x1,rel_x2;
  bool menu_enabled;

  if (!f_open)
    return;

  menu=m_menu_number_to_menu(menu_nb);
  caption=menu->m_get_caption();
  menu_enabled=menu->m_is_enabled();

  m_get_menu_caption_pos(menu_nb,rel_x1,rel_x2);

  if (f_active_menu!=NULL)
    selected_menu_nb=f_active_menu->f_menu_nb;

  if (selected_menu_nb==menu_nb)
    f_window->m_textattr((BLACK<<4)+(unsigned)((menu_enabled)?WHITE:LIGHTGRAY));
  else
    f_window->m_textattr((f_background<<4)
		       +((menu_enabled)?BLACK:LIGHTGRAY));
  f_window->m_gotoxy(rel_x1,m_get_y_in_window());

  f_window->m_put_caption(caption,menu_enabled,rel_x2-rel_x1+1,CENTERED_LEFT);
}

void TMenuBar::m_close_menu()
{
  PMenu menu;

  if (f_active_menu==NULL)
    return;

  menu=f_active_menu;
  f_active_menu=NULL;
  menu->f_window->m_close();
  menu->m_set_selected_item_index(0);
  m_display_menu_caption(menu->f_menu_nb);
}

bool TMenuBar::m_open_menu(int menu_nb,bool select_first_possible)
{
  PMenu       menu;
  int         y_menubar;
  int         x_menu,y_menu;
  int         menu_width,menu_height;
  int         tmp;

  menu=m_menu_number_to_menu_node(menu_nb)->menu;

  if (!(menu->m_is_enabled()))
    return false;

  // L'objet de la fentre possdant le focus ne veut pas le lacher

//  if (!f_window->m_can_lose_focus())
//    return false;

  // La barre de menu n'est pas active

  if (!f_active)
    m_activate_menu_bar();

  m_close_menu();
  f_active_menu=menu;
  menu->m_set_first_visible_item_index(1);
  if (select_first_possible)
    menu->m_select_first_possible_item();

  // Si besoin, on recalcule la taille du menu

  menu->m_adjust_size();

  // On positionne la fentre du menu

  y_menubar=m_get_y();
  menu_height=menu->f_window->m_get_height();
  menu_width =menu->f_window->m_get_width();

  if ((GetScreenHeight()-y_menubar)>=menu_height)
    y_menu=y_menubar+1;
  else
    y_menu=y_menubar-menu_height;

  x_menu=m_get_x()+m_get_menu_caption_pos1(menu_nb);

  if (x_menu<1)
    x_menu=1;

  tmp=GetScreenWidth();
  if (x_menu+menu_width>tmp+1)
    x_menu=tmp+1-menu_width;

  menu->f_window->m_set_pos(x_menu,y_menu);

  // et on l'affiche

  menu->f_window->m_open_as_object_element(this);

  m_display_menu_caption(menu_nb);
  return true;
}

/****************************************************************************/
/* m_get_tab_caption_pos                                                    */
/*--------------------------------------------------------------------------*/
/* Retourne les coordonnes du titre de l'onglet                            */
/****************************************************************************/

int TMenuBar::m_get_menu_caption_pos1(int menu_nb)
{
  int rel_x1,rel_x2;

  if (menu_nb>f_nb_menus)
    {
      if (menu_nb>1)
        {
	  m_get_menu_caption_pos(menu_nb-1,rel_x1,rel_x2);
          return(rel_x2+1);
	}
      return(1);
    }

  m_get_menu_caption_pos(menu_nb,rel_x1,rel_x2);
  return(rel_x1);
}

void TMenuBar::m_get_menu_caption_pos(int menu_nb,int &rel_x1,int &rel_x2)
{
  PMenuNode node=f_menu_list;
  register int i;

  JPDEBUG_TEST(DEBUG_ERROR_28,(menu_nb>=1) && (menu_nb<=f_nb_menus));

  rel_x1=1;

  for (i=1;i<menu_nb;i++,node=node->next)
    rel_x1+=DisplayLength((node->menu)->m_get_caption())+2;

  rel_x2=rel_x1+DisplayLength(node->menu->m_get_caption())+1;

}

void TMenuBar::m_activate_menu_bar()
{
  if (f_active)
    return;

  f_active=true;

  f_cursor_was_visible=TextCursorIsVisible();

  if (f_cursor_was_visible)
    HideTextCursor();

  // Sauve le message d'info de la fenetre
  // et efface le message actuel

  const char *msg = f_window->m_get_info_message();
  f_window_info_message=new char [strlen(msg)+1];
  strcpy(f_window_info_message,msg);
  f_window->m_set_info_message("");

}

void TMenuBar::m_inactivate_menu_bar()
{
  if (!f_active)
    return;

  m_close_menu();

  f_active=false;

  f_window->m_set_info_message(f_window_info_message);
  delete []f_window_info_message;
  f_window_info_message=NULL;

  if (f_cursor_was_visible)
    ShowTextCursor();
}

/***********************************************************/
/* m_menu_number_to_menu : Retourne un menu  partir */
/* -------------------------   de son numro (1...)        */
/***********************************************************/

PMenu TMenuBar::m_menu_number_to_menu(int menu_number)
{
  return(m_menu_number_to_menu_node(menu_number)->menu);
}

/***********************************************************************/
/* m_menu_number_to_menu_node : Retourne un pointeur sur l'lment de  */
/* ---------------------------  la liste des lments de l'objet      */
/*                              partir de son numro dans le groupe.   */
/***********************************************************************/

PMenuNode TMenuBar::m_menu_number_to_menu_node(int menu_number)
{
  PMenuNode node;
  register int i;

  JPDEBUG_TEST(DEBUG_ERROR_28,(menu_number>=1) && (menu_number<=f_nb_menus));

  node=f_menu_list;
  for (i=1;i<menu_number;i++)
    node=node->next;

  return(node);
}
