/****************************************************************************/
/* TDECEDZN                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TDecimalEditZone (Zone d'dition d'un nombre dcimal)              */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "Settings.h"

#include "Vocab.h"

#include "Strings.h"

#include "TDecEdZn.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de la zone d'dition p/r au groupe        */
/* xoffset_caption,                                                         */
/* yoffset_caption  : Coordonnes du titre p/r au contenu de la zone d'dit.*/
/* caption          : Titre de la zone d'dition (hot-key prcd de ~)     */
/* display_length   : Longueur visible du contenu de la zone d'dition      */
/* max_length       : Longueur maximale du contenu de la zone d'dition     */
/* min_value,                                                               */
/* max_value        : Valeurs minimale et maximale pouvant tre saisies     */
/* string           : Contenu initial de la zone d'dition                  */
/* enabled          : ENABLED si la zone est activable (DISABLED sinon)     */
/****************************************************************************/

TDecimalEditZone::TDecimalEditZone(PObject parent,
		                   int rel_x, int rel_y,
		                   int xoffset_caption, int yoffset_caption,
                                   const char *caption,
                                   int display_length,
		                   int max_length,
		                   double min_value,double max_value,
				   const char *string,
				   boolean enabled)
		 :TEditZone(parent,
			    rel_x,rel_y,
			    xoffset_caption,yoffset_caption,
			    caption,
			     display_length,
			    max_length,
			    string,
			    enabled)
{
  // Valeurs min et max
  // Corrige la chane si elle est invalide
  // (le constructeur de TEditZone n'ayant pas appel la bonne fonction
  // m_valid_string, et parce que la valeur peut tre hors limites)

  m_set_min_max_values(min_value,max_value);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TDecimalEditZone::~TDecimalEditZone()
{
}

/****************************************************************************/
/* m_set_min_max_values                                                     */
/*--------------------------------------------------------------------------*/
/* Modifie les valeurs min et max de la zone de saisie                      */
/****************************************************************************/

void TDecimalEditZone::m_set_min_max_values(double min_value,double max_value)
{
  char string[DOUBLE_MAX_LENGTH];

  double value;
  boolean invalid;

  if (max_value<min_value)
    max_value=min_value;

  f_min_value=min_value;
  f_max_value=max_value;

  // Correction de la chane par dfaut

  invalid=TRUE;
  if (StringToDouble(f_default_string,value))
    if ((value>=min_value) && (value<=max_value))
      invalid=FALSE;

  if (invalid)
    {
      value=min_value;
      DoubleToString(value,string);
      delete []f_default_string;
      f_default_string=new char [strlen(string)+1];
      strcpy(f_default_string,string);
    }

  m_set_string(m_get_string());

}

/*****************************************************/
/* m_string_valid : Indique si une chane est valide */
/* --------------   pour ce type de zone de saisie   */
/*****************************************************/

boolean TDecimalEditZone::m_string_valid(const char *string)
{
  double value;

  int string_length=strlen(string);

  if (string_length==0)
    return(FALSE);

  // Chane trop longue ?

  if (string_length>f_max_length)
    return(FALSE);

  // C'est une chane valide pour un double

  if (!StringToDouble(string,value))
    return(FALSE);

  // Valeur dans les limites autorises

  value=atof(string);
  if ((value<f_min_value) || (value>f_max_value))
    return(FALSE);

  return(TRUE);
}


/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**************************************************************/
/* m_valid_character : Indique si un caractre est acceptable */
/* -----------------   par ce type de zone de saisie          */
/**************************************************************/

boolean TDecimalEditZone::m_character_valid(int character)
{
  if (   ((character>='0')&&(character<='9'))
      || (character=='.')
      || (character=='+')
      || (character=='-')
      || (character==' '))
    return(TRUE);

  return(FALSE);
}

/****************************************************************************/
/* m_get_error_message                                                      */
/*--------------------------------------------------------------------------*/
/* Retourne un message indiquant pourquoi la chaine n'est pas valide        */
/****************************************************************************/

const char *TDecimalEditZone::m_get_error_message()
{
  const char *msg=GetString(VOC_MUST_BE_DECIMAL_BETWEEN);

  if (f_error_message!=NULL)
    delete []f_error_message;

  f_error_message=new char [strlen(msg)+DOUBLE_MAX_LENGTH+DOUBLE_MAX_LENGTH-4+1];
  sprintf(f_error_message,msg,f_min_value,f_max_value); // pour un double

  return(f_error_message);
}

