/****************************************************************************/
/* TPASSEDZ                                                                 */
/*--------------------------------------------------------------------------*/
/* Class TPasswordEditZone (password editing zone)                          */
/* TEDZONE                                                                  */
/*--------------------------------------------------------------------------*/
/* Author     : DELPRAT Jean-Pierre                                         */
/* Created    : 11/02/95                                                    */
/****************************************************************************/

#include "Const.h"

#include "TWindow.h"

#include "TPassEdz.h"

/*ͻ*/
/*                 INITIALISATION DES VARIABLES STATIQUES                 */
/*ͼ*/

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de la zone d'dition p/r au groupe        */
/* xoffset_caption,                                                         */
/* yoffset_caption  : Coordonnes du titre p/r au contenu de la zone d'dit.*/
/* caption          : Titre de la zone d'dition (hot-key prcd de ~)     */
/* display_length   : Longueur visible du contenu de la zone d'dition      */
/* max_length       : Longueur maximale du contenu de la zone d'dition     */
/* string           : Contenu initial de la zone d'dition                  */
/* enabled          : ENABLED si la zone est activable (DISABLED sinon)     */
/****************************************************************************/

TPasswordEditZone::TPasswordEditZone(PObject parent,
				     int rel_x,int rel_y,
				     int xoffset_caption,int yoffset_caption,
				     char *caption,
				     int display_length,
				     int max_length,
				     char *string,
				     boolean enabled)
		  :TEditZone(parent,
			     rel_x,rel_y,
			     xoffset_caption,yoffset_caption,
			     caption,
			     display_length,
			     max_length,
			     string,
			     enabled)
{
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TPasswordEditZone::~TPasswordEditZone()
{
}

/****************************************************************************/
/* m_display_string_chars                                                   */
/*--------------------------------------------------------------------------*/
/* Appele par m_display_string                                              */
/****************************************************************************/

void TPasswordEditZone::m_display_string_chars(unsigned background,int last_visible_char)
{
  int  ptr1,ptr2;
  int  last_true_visible_char;

  // EditZone avec focus et zone slectionne

  ptr1=f_first_visible_char;
  last_true_visible_char=MIN(f_useful_length-1,last_visible_char);

  if ((f_focused) && (f_window->m_is_active()) && (f_zone_selected))
    {
      ptr2=MIN(f_min_selected_char-1,last_true_visible_char)+1;

      if (ptr1<ptr2)
	{
	  f_window->m_putnch(ptr2-ptr1,'*');
	  ptr1=ptr2;
	}

      f_window->m_set_inverse_attr(f_background);

      ptr2=MIN(f_max_selected_char,last_true_visible_char)+1;

      if (ptr1<ptr2)
	{
	  f_window->m_putnch(ptr2-ptr1,'*');
	  ptr1=ptr2;
	}

      f_window->m_textattr(background);

      ptr2=last_true_visible_char+1;
      if (ptr1<ptr2)
	{
	  f_window->m_putnch(ptr2-ptr1,'*');
	  ptr1=ptr2;
	}
    }

  // Sinon

  else
    {
      ptr2=last_true_visible_char+1;
      if (ptr1<ptr2)
	{
	  f_window->m_putnch(ptr2-ptr1,'*');
	  ptr1=ptr2;
	}
    }

  // Affichage de la partie de la chaine avec des '.'

  ptr2=last_visible_char+1;
  if (ptr1<ptr2)
    f_window->m_putnch(ptr2-ptr1,'');
}