/********************************************************


                         CEKANI

           .ANI File Loader Library to DJGPP.

      Copyright (c) 2000 by Cristian EmmericK (CEK)

              E-mail: cek@mailbr.com.br

                 ICQ(UIN): 52438873


*********************************************************

                        FILE INFO:

  EX01.C

  Example 01, demostrate how to load and show the .ANI
file.


********************************************************/



#include "allegro.h"

#include "cekani.h"

void main()
{
  /* bitmap for screen */
  BITMAP *bmp;

  /* declare a cursor type */
  CURSOR *cursor;

  /* declare a int to keep the current frame */
  int frame=0;

  /* init allegro */
  allegro_init();

  /* init keyboard */
  install_keyboard();

  /* set color depth and set the graphic mode */
  set_color_depth(8);
  set_gfx_mode(GFX_AUTODETECT,640,480,0,0);

  /* load .ANI file */
  cursor=load_ani("cmastree.ani");
  if(!cursor) {allegro_exit(); printf("Loading error!");}


  /* set .ANI file pallete */
  set_pallete(cursor_pallete(cursor,0));

  /* create a bitma to screen */
  bmp=create_bitmap(640,480);


  while(!key[KEY_ESC])
  {

    if(key[KEY_RIGHT]) frame++;
    if(key[KEY_LEFT])  frame--;

    clear_keybuf();

    if(frame<0) frame=0;
    if(frame>cursor_frames(cursor)-1) frame=cursor_frames(cursor)-1;

    clear_to_color(bmp,0);


    /* put the current frame image to screen */
    cursor_blit(bmp,cursor,frame,0,0);

    blit(bmp,screen,0,0,0,0,bmp->w,bmp->h);

  }

  /* remove keyboard */
  remove_keyboard();

  /* uinit allegro */
  allegro_exit();
}
