/* getvolinfo.c -- get volume information
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_get_volume_information(
		IN LPCSTR lpRootName,
		OUT LPSTR lpFsName,
		IN WORD nFsNameSize,
		OUT PVOLINFO lpVolInfo			
		)
{
	DWORD dwSerialNumber;
	DWORD dwMaxComponentLength;
	DWORD dwFlags;
	WORD result;

	PROLOG(process_get_volume_information);
	IS_NULL(lpRootName, ERROR_PATH_NOT_FOUND);
	DBGVALUE(lpRootName,"%s");
	DBGVALUE(nFsNameSize,"%d");

	if (!GetVolumeInformation(lpRootName, NULL, 0, &dwSerialNumber,
		&dwMaxComponentLength, &dwFlags, lpFsName, nFsNameSize)) {
		result = (WORD)GetLastError();
		EPILOG(process_get_volume_information, FALSE);
		return result;
	}

	if (lpVolInfo) {
		lpVolInfo->filename_maxlen = (WORD) dwMaxComponentLength;
		lpVolInfo->pathname_naxlen = (WORD) dwMaxComponentLength +3;
	
		lpVolInfo->volflags 	  = 0;
		if (dwFlags & FS_CASE_SENSITIVE     ) 
			lpVolInfo->volflags |= DOS_FS_CASE_SENSITIVE;	 
		if (dwFlags & FS_CASE_IS_PRESERVED  ) 
			lpVolInfo->volflags |= DOS_FS_CASE_IS_PRESERVED; 
		if (dwFlags & FS_UNICODE_STORED_ON_DISK    ) 
			lpVolInfo->volflags |= DOS_FS_UNICODE_ON_DISK;   
		if (dwFlags & FS_FILE_COMPRESSION || dwFlags & FS_VOL_IS_COMPRESSED ) 
			lpVolInfo->volflags |= DOS_FS_VOLUME_COMPRESSED;

		if (lpVolInfo->filename_maxlen > 13)
			lpVolInfo->volflags |= DOS_FS_LFN_APIS;

		DBGVALUE(lpVolInfo->filename_maxlen ,"%ld");
		DBGVALUE(lpVolInfo->volflags ,"%ld");
	}	
	
	if (lpFsName)
		DBGVALUE(lpFsName,"%s");
	EPILOG(process_get_volume_information, TRUE);
	return ERROR_SUCCESS;
}
