/*****************************************************************************

  This code is copyrighted by Salvador Eduardo Tropea. (c) 1996.

  You can use, distribute and modify this code with the following
restrictions:

1) You can't remove this text.
2) You must say who is the original author.
3) You can't receive money for this files, this includes the binarys
generated with this sources, without my consent. (only a minimal amount for
the media is allowed without my consent (floppy disk <= 5 U$S, CD <= U$S 35)).
4) You can't modify the copyrights inside inflibc.spa and inflibc.eng, and
if you generate a convertion from libc.inf this convertion must include
inflibc.spa or inflibc.eng.

  The following aren't restictions but requests:

1) If you find any bug please inform it to me.
2) If you make enhacements or derivated work share it with me.
3) If you use this code or the files generated e-mail, or send a letter,
to me.

  Some of the projects i have in mind are the followings:

1) A FAQ's to NG coverter (seems to be easy)
2) A TEX to NG converter (not so easy)
3) A generic INF to NG converter (i'm developing it)

  If you plan to do some of these, e-mail to me.

  Share and enjoy, but not abuse.

E-Mail: ice@inti.edu.ar

Telephone: (+541) 759-0013

Postal Address:
Salvador E. Tropea
Curapalige 2124
(1678) Caseros - 3 de Febrero
Prov: Buenos Aires
Argentina

*****************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

#include "setstd.h"
#include "compila.hpp"

#ifdef TEXTO_EN_DISCO
FILE *fTemp;
#define NGShort(a) NGShort(a,fTemp)
#endif

#ifdef __GNUC__

#include <go32.h>
#include <dpmi.h>

ULONG farcoreleft(NADA)
{
 _go32_dpmi_meminfo info;
 _go32_dpmi_get_free_memory_information(&info);
 if (info.available_physical_pages != -1)
   return info.available_physical_pages * 4096;
 return info.available_memory;
}

#else // !__GNUC__

#define inline
#include <alloc.h>

#endif

//#define ESPANOL

#ifdef ESPANOL

#define S_NomLib "Librera Standard de GCC"
#define S_Intro  "Introduccin"
#define S_IntroT "Textos Introductorios"
#define S_Funcs  "Funciones"
#define S_FuncsN "Funciones por Nombre"
#define S_ECrea1 "Error al crear %s\n"
#define S_CreCat "Creando categora:"
#define S_FuncsC "Funciones por Categora"
#define S_NomLi2 "Librera Standard de GCC (p/Categora)"
#define S_EAbre1 "Error al abrir %s\n"
#define S_Mide   "Midiendo el archivo ... "
#define S_CopyF  "Copiando funcin"
#define S_ENoNod "No pude encontrar el nodo"
#define S_Reco   "Recolectando los nodos y notes ... "
#define S_NLN    "Nodos: %d Lneas: %d Notas"
#define S_NoRAM  "No hay RAM suficiente\n"
#define S_MiCopy "Convertido a NG por SET (Salvador Eduardo Tropea)\n"
#define S_IDIO   "SPA"
#define S_Tiempo "Tiempo de conversin,compilado y linkeado: %f segundos\n" 
#define S_CreaPorNom "Creando funciones por nombre"
#define S_CreaPorCat "Creando funciones por categora"
#define S_MemoLibre  "Memoria libre: %ld\n"
#define S_FuncCrea   "Creadas %d funciones\n"
#define S_LargoTot   "Largo total: %ld\n"
#define S_NomPrg     "Conversor de libc.inf a NG. (c) 1996 por SET (Salvador E. Tropea)\n\n"

#else

#define S_NomLib "Standard GCC Lib"
#define S_Intro  "Introduction"
#define S_IntroT "Introduction Texts"
#define S_Funcs  "Functions"
#define S_FuncsN "Functions by Name"
#define S_ECrea1 "Can't create: %s\n"
#define S_CreCat "Creating category:"
#define S_FuncsC "Functions by Category"
#define S_NomLi2 "Standard GCC Lib (by Category)"
#define S_EAbre1 "Can't open: %s\n"
#define S_Mide   "First pass to the archive ... "
#define S_CopyF  "Copying function"
#define S_ENoNod "Can't find the node"
#define S_Reco   "Collecting nodes and notes ... "
#define S_NLN    "Nodes: %d Lines: %d Notes"
#define S_NoRAM  "Not enough memory\n"
#define S_MiCopy "Converted to NG by SET (Salvador Eduardo Tropea)\n"
#define S_IDIO   "ENG"
#define S_Tiempo "Convertion/Compile/Link time: %f segs\n"
#define S_CreaPorNom "Creating functions by name"
#define S_CreaPorCat "Creating functions by category"
#define S_MemoLibre  "Free memory: %ld\n"
#define S_FuncCrea   "%d functions created\n"
#define S_LargoTot   "Total size: %ld\n"
#define S_NomPrg     "libc.inf to NG converter. (c) 1996 by SET (Salvador E. Tropea)\n\n"

#endif

FILE *h,*hl;
char Buff[256+2];
char Buff2[256+2];

char NomFile[20];
/****
char NomNodo[20];
char NomNext[20];
char NomPrev[20];
char NomUp[20];
****/

typedef struct
{
 char Nombre[70];
 long Pos;
} iNodo;

typedef struct
{
 char Nodo[70];
 char Nota[70];
} iNota;

iNodo *Nodos;
iNota *Notas;
int CantNodos=0;
int CantNotas=0;


int SaltearNodo(void);
int TomarNombreNodo(char *);

void ErrorMem(void)
{
 printf(S_NoRAM);
 exit(1);
}


char BufMFile[32000];
char *ucpPosMFile=BufMFile;
WORD uiLineasMFile;

inline
void RebobinaMFile()
{
 ucpPosMFile=BufMFile;
 uiLineasMFile=0;
}

void PoneEnMFile(char *s)
{
 for (;*s;ucpPosMFile++,s++)
     *ucpPosMFile=*s;
 *ucpPosMFile=0;
 ucpPosMFile++;
 uiLineasMFile++;
}


FILE *AbrirArchivo(char *nom,char *modo)
{
 FILE *f;
 if ((f=fopen(nom,modo))==NULL)
   {
    printf(S_EAbre1,nom);
    exit(1);
   }
 return f;
}

inline
void TomarLinea(void)
{
 fgets(Buff,256,h);
}

int SaltearNodoNotas(void)
{
 int Salteadas=0;

 do
  {
   TomarLinea();
   if (strstr(Buff,"*note")!=NULL || strstr(Buff,"*Note")!=NULL ) CantNotas++;
   Salteadas++;
  }
 while (Buff[0]!=31 && !feof(h));

 return Salteadas;
}


void CrearIndice(void)
{
 int CantLineas=0;
 char *s1,*s2,*s,*sb;
 char Molinete[]={ '','/','-','\\' };

 do
  {
   CantLineas+=SaltearNodoNotas();
   CantNodos++;
   printf("\x8%c",Molinete[CantNodos & 3]);
  }
 while(!feof(h));
 printf("\x8 \n" S_NLN ": %d => %u+%u bytes\n",
        CantNodos,CantLineas,CantNotas,CantNodos*sizeof(iNodo),
        CantNotas*sizeof(iNota));
 fseek(h,0,SEEK_SET);

 if ((Nodos=(iNodo *)malloc(CantNodos*sizeof(iNodo)))==NULL) ErrorMem();
 if ((Notas=(iNota *)malloc(CantNotas*sizeof(iNota)))==NULL) ErrorMem();

 memset((void *)Nodos,0,CantNodos*sizeof(iNodo));
 memset((void *)Notas,0,CantNotas*sizeof(iNota));

 CantNodos=0;
 CantNotas=0;
 SaltearNodo();
 printf(S_Reco);
 do
  {
   TomarNombreNodo(Nodos[CantNodos].Nombre);
   Nodos[CantNodos].Pos=ftell(h);
   // Saltear el nodo buscando las Note
   do
    {
     TomarLinea();
     s1=strstr(Buff,"*note");
     s2=strstr(Buff,"*Note");
     if (s1!=NULL || s2!=NULL )
       {
        // Buscar el nombre
        if (s1==NULL)
           s=s2+6;
        else
           s=s1+6;
        sb=s;
        s2=s-1;
        for (; *s && *s!=':' && *s2!=':'; s++,s2++);
        // Puede que contine en la prxima linea => lo descarto
        if (*s)
          {
           *s=0;
           strcpy(Notas[CantNotas].Nodo,Nodos[CantNodos].Nombre);
           strcpy(Notas[CantNotas].Nota,sb);
           CantNotas++;
          }
       }
     printf("\x8%c",Molinete[CantNodos & 3]);
    }
   while (Buff[0]!=31 && !feof(h));

   CantNodos++;
  }
 while(!feof(h));

 fseek(h,0,SEEK_SET);
}

int CopiarNodo(void)
{
 do
  {
   TomarLinea();
   if (Buff[0]!=31)
     {
      if (Buff[0]=='!') Buff[0]='*';
      PoneEnMFile(Buff);
     }
  }
 while (Buff[0]!=31 && !feof(h) && !kbhit());
 return 0;
}

int CopiarNodoSubra(void)
{
 do
  {
   TomarLinea();
   if (Buff[0]!=31)
     {
      if (Buff[0]=='!') Buff[0]='*';
      if (strcmp(Buff,"Syntax\n")==0 ||
          strcmp(Buff,"Description\n")==0 ||
          strcmp(Buff,"Return Value\n")==0 ||
          strcmp(Buff,"Example\n")==0 )
        {
         Buff[strlen(Buff)-1]=0;
         sprintf(Buff2,"^B%s^B\n",Buff);
         PoneEnMFile(Buff2);
         TomarLinea();
        }
      else
         PoneEnMFile(Buff);
     }
  }
 while (Buff[0]!=31 && !feof(h) && !kbhit());
 return 0;
}

int SaltearNodo(void)
{
 int Salteadas=0;

 do
  {
   TomarLinea();
   Salteadas++;
  } 
 while (Buff[0]!=31 && !feof(h) && !kbhit());
 
 return Salteadas;
}

char *TomaHastaComa(char *Destino, char *Fuente)
{
 for (;*Fuente!=':' && *Fuente; Fuente++);
 for (Fuente+=2; *Fuente!=',' && *Fuente; Fuente++,Destino++)
     *Destino=*Fuente;
 *Destino=0;
 
 return Fuente;
}

/**********
int TomarInfoNodo(void)
{
 char *Pos;

 TomarLinea();
 puts(Buff);
 // File:
 Pos=TomaHastaComa(NomFile,Buff);
 // Node:
 Pos=TomaHastaComa(NomNodo,Pos);
 // Next:
 Pos=TomaHastaComa(NomNext,Pos);
 // Prev:
 Pos=TomaHastaComa(NomPrev,Pos);
 // Up:
 Pos=TomaHastaComa(NomUp,Pos);
 printf("Archivo: %s, Nodo: %s\n Prox: %s, Prev: %s, Arriba: %s\n\n",NomFile,NomNodo,NomNext,NomPrev,NomUp);
 return 0;
}
***********/

int TomarNombreNodo(char *Nom)
{
 char *Pos;

 TomarLinea();
 //puts(Buff);
 // File:
 Pos=TomaHastaComa(NomFile,Buff);
 // Node:
 Pos=TomaHastaComa(Nom,Pos);
 return 0;
}


int TraduceNodo1(NGVariosShort& o,NGListaPura& Lp)
{
 RebobinaMFile();
 //TomarInfoNodo();
 TomarLinea();
 // Vaco
 TomarLinea();
 // Nombre
 TomarLinea();

 Buff[strlen(Buff)-1]=0;
 NGShort *oc = new NGShort(Buff);
 sprintf(Buff2,"^B%s^B\n",Buff);
 PoneEnMFile(Buff2);
 // Subrayado
 TomarLinea();
 // Vaco
 TomarLinea();
 CopiarNodo();
 oc->PonerTexto(BufMFile,uiLineasMFile);
 o.Agregar(*oc,Lp);
 return 0;
}

int TraduceNodo2(void)
{
 RebobinaMFile();
 // Vaco
 TomarLinea();
 // Nombre
 TomarLinea();
 Buff[strlen(Buff)-1]=0;
 sprintf(Buff2,"^B%s^B\n",Buff);
 PoneEnMFile(Buff2);
 // Subrayado
 TomarLinea();
 CopiarNodoSubra();
 return 0;
}



int BuscaNodo(char *Nombre)
{
 int i;

 for (i=0; i<CantNodos && strcmp(Nodos[i].Nombre,Nombre)!=0; i++);
 if (i==CantNodos)
   {
    printf("Error: " S_ENoNod ": %s\n",Nombre);
    exit(1);
   }

 fseek(h,Nodos[i].Pos,SEEK_SET);

 return 1;
}

void TomarNomLink(char *C)
{
 char *F,*An;
 
 TomarLinea();
 for (F=Buff; *F==' ' || *F=='*'; F++);
 for (An=F-1; *F!=':' && *An!=':'; F++,An++,C++) *C=*F;
 *C=0;
}

char *Categorias;
char *TItems;

int EstudiaNodo(char *Nombre,char **Strs)
{
 long PosTemp;
 long PosDatos;
 int CantItems,i;

 PosTemp=ftell(h);
 BuscaNodo(Nombre);
 TomarLinea();
 TomarLinea();
 TomarLinea();
 TomarLinea();
 TomarLinea();
 TomarLinea();

 PosDatos=ftell(h);
 CantItems=SaltearNodo()-2;
 //printf("Items: %d\n",CantItems);
 if ((*Strs=(char *)malloc(CantItems*80))==NULL) ErrorMem();
 fseek(h,PosDatos,SEEK_SET);

 for (i=0; i<CantItems; i++)
    {
     TomarNomLink(*Strs+80*i);
     //puts(*Strs+80*i);
    }

 fseek(h,PosTemp,SEEK_SET);

 return CantItems;
}


int PrimeraLetraDe(char *s)
{
 for (; *s && (toupper(*s)<'A' || toupper(*s)>'Z'); s++);
 return toupper(*s);
}

void GenerarFuncion(char *n,NGVariosShort& Padre, NGListaPura& Lp)
{
 int i;

 //printf("   " S_CopyF ": %s\n",n);
 NGShort *o = new NGShort(n);
 for (i=0; i<CantNotas; i++)
    {
     if (strcmp(Notas[i].Nodo,n)==0)
        o->AgregarSeeAlso(Notas[i].Nota);
    }
 BuscaNodo(n);
 TraduceNodo2();
 o->PonerTexto(BufMFile,uiLineasMFile);
 Padre.Agregar(*o,Lp);
}

void CopiarCredito(NGArchivo& o)
{
 TomarLinea();
 TomarLinea();
 TomarLinea();
 TomarLinea();
 // This is ...
 o.AgregarCopy(Buff);
 TomarLinea();
 TomarLinea();
 // Copy...
 o.AgregarCopy(Buff);
 o.AgregarCopy(S_MiCopy);
 o.AgregarCopy("Buenos Aires, Argentina. e-mail ice@inti.edu.ar\n");
 SaltearNodo();
}

void CompilarArchivo(char *NomArch,NGVariosShort& Padre,NGListaPura& Lp)
{
 FILE *f=AbrirArchivo(NomArch,"rt");

 fgets(Buff,256,f);
 while(!feof(f))
   {
    if (strncmp(Buff,"!Short:",7)==0)
      {// OK crear un tipo 1
       Buff[strlen(Buff)-1]=0;
       NGShort *o = new NGShort(&Buff[7]);
       fgets(Buff,256,f);
       if (!(strncmp(Buff,"!Short:",7)==0)) // Separador
         {
          if (strncmp(Buff,"!SeeAlso:",9)==0)
            {
             char *aux;

             strtok(Buff,":");
             while ((aux=strtok(NULL,":"))!=NULL)
               {
                int l=strlen(aux)-1;
                if (aux[l]=='\n')
                   aux[l]=0;
                o->AgregarSeeAlso(aux);
               }
             fgets(Buff,256,f);
            }
          RebobinaMFile();
          do
           {
            PoneEnMFile(Buff);
            fgets(Buff,256,f);
           }
          while(Buff[0]!='!' && !feof(f));
          o->PonerTexto(BufMFile,uiLineasMFile);
         }
       Padre.Agregar(*o,Lp);
      }
   }
 fclose(f);
}


int ProcesaInfo(char *Arch,char *Lnk)
{
 int i,Cant;
 char NomFC[13];
 int Indice=0;
 FILE *hc;

 printf(S_MemoLibre,farcoreleft());
 h=AbrirArchivo(Arch,"rt");

 printf(S_Mide);
 CrearIndice();
 printf("\x8 \n");

 #ifdef TEXTO_EN_DISCO
 fTemp=AbrirArchivo("__infa__.tmp","wb");
 #endif

 // Crear el archivo
 NGArchivo Ar(Lnk,S_NomLib);
 CopiarCredito(Ar);

 // Crear menes
 NGMenu M1(S_Intro);
 NGMenu M2(S_Funcs);
 Ar.Agregar(M1);
 Ar.Agregar(M2);

 // Crear la copa del rbol
 NGListaPura Lp;

 // Crear sus opciones
 NGVariosShort M11(""); // Sin nombre por desprenderse de un men
 M1.Agregar(M11,S_IntroT,Lp);
 NGVariosShort M21(""); // Sin nombre por desprenderse de un men
 M2.Agregar(M21,S_FuncsN,Lp);
 NGVariosShort M22(""); // Sin nombre por desprenderse de un men
 M2.Agregar(M22,S_FuncsC,Lp);

 // Ir al texto introductorio
 SaltearNodo();
 TraduceNodo1(M11,Lp);
 // Agregar desde un archivo fuente
 CompilarArchivo("InfLibc." S_IDIO,M11,Lp);

 // Ahora M21, las funciones
 Cant=EstudiaNodo("Alphabetical List",&Categorias);

 puts(S_CreaPorNom);
 for (Indice=0; Indice<Cant; Indice++)
 //for (Indice=0; Indice<5; Indice++)
     GenerarFuncion(&Categorias[80*Indice],M21,Lp);
 printf(S_FuncCrea,Cant);

 free(Categorias);

 // Ahora M22, por categora
 puts(S_CreaPorCat);
 Cant=EstudiaNodo("Functional Categories",&Categorias);
 int k;
 for (i=0,k=0; i<Cant; i++)
    {
     int CantL;
     int j;

     NGVariosShort *o = new NGVariosShort(&Categorias[80*i]);

     CantL=EstudiaNodo(&Categorias[80*i],&TItems);
     for (j=0; j<CantL; j++,k++)
        {
         GenerarFuncion(&TItems[80*j],*o,Lp);
        }
     free(TItems);

     M22.Agregar(*o,Lp);

     fclose(hl);
    }
 printf(S_FuncCrea,k);
 printf(S_MemoLibre,farcoreleft());
 free(Categorias);

 // Linkear
 printf(S_LargoTot,Ar.ResolverPosiciones(0));
 Lp.ResolverPosiciones();
 FILE *f;
 Ar.Grabar(0,f);

 fclose(h);

 #ifdef TEXTO_EN_DISCO
 fclose(fTemp);
 remove("__infa__.tmp");
 #endif

 return 0;
}

int main()
{
 clock_t t1,t2;
 printf(S_NomPrg);

 t1=clock();
 ProcesaInfo("libc.inf","libc.ng");
 t2=clock();
 printf(S_Tiempo,(float)(t2-t1)/CLOCKS_PER_SEC);
 printf("Memoria libre: %ld\n",farcoreleft());

 return 0;
}