/******************************** -*- C -*- ****************************
 *
 *	`dlopen' (Solaris/Linux) Dynamic Linking support code
 *
 *	$Revision: 1.7.5$
 *	$Date: 2000/05/28 16:56:52$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Paolo Bonzini.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/


#include "dld_gst.h"
#include <dlfcn.h>
#include <stdio.h>

char	*gst_dld_exts[] = { ".so", ".a", NULL };

#ifdef RTLD_LAZY
# define LINK_MODE RTLD_LAZY
#else
# ifdef DL_LAZY
#  define LINK_MODE DL_LAZY
# else
#  ifdef RTLD_NOW
#   define LINK_MODE RTLD_NOW
#  else
#   ifdef DL_NOW
#    define LINK_MODE DL_NOW
#   else
#    error broken dlfcn.h -- please reconfigure without DLD
#   endif
#  endif
# endif
#endif

voidPtr
gst_dld_open (path)
     char *path; 
{
  return dlopen(path, LINK_MODE);
}

voidPtr
gst_dld_sym (handle, symbol)
voidPtr handle;
     char *symbol;
{
  return dlsym(handle, symbol);
}

char *
gst_dld_error ()
{
  return dlerror();
}

int
gst_dld_init (dldArgv0)
     char *dldArgv0;
{
  return 0;
}

