/* Intel P6 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 1999, 2000, 2001 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


#define BITS_PER_MP_LIMB 32
#define BYTES_PER_MP_LIMB 4


#ifndef UMUL_TIME
#define UMUL_TIME   5   /* cycles */
#endif
#ifndef UDIV_TIME
#define UDIV_TIME   39  /* cycles */
#endif

/* A test with gcc 2.95.2 on mpn_sb_divrem_mn suggests that in practice
   udiv_qrnnd_preinv is about 10 cycles faster than plain udiv_qrnnd. */
#ifndef UDIV_NORM_PREINV_TIME
#define UDIV_NORM_PREINV_TIME   31 /* cycles */
#endif

#ifndef COUNT_TRAILING_ZEROS_TIME
#define COUNT_TRAILING_ZEROS_TIME   2  /* cycles */
#endif


/* 800MHz P-III, gcc 2.95.2 (and 200MHz P6 with gcc 2.7.2.3 is similar) */

/* Generated by tuneup.c, 2001-11-28, gcc 2.95 */

#define KARATSUBA_MUL_THRESHOLD       23
#define TOOM3_MUL_THRESHOLD          164

#define BASECASE_SQR_THRESHOLD         0
#define KARATSUBA_SQR_THRESHOLD       50
#define TOOM3_SQR_THRESHOLD          202

#define SB_PREINV_THRESHOLD            4
#define DC_THRESHOLD                 111
#define POWM_THRESHOLD               142

#define GCD_ACCEL_THRESHOLD            3
#define GCDEXT_THRESHOLD              45

#define USE_PREINV_MOD_1               1  /* (native) */
#define DIVREM_2_THRESHOLD             0
#define DIVEXACT_1_THRESHOLD           0
#define MODEXACT_1_ODD_THRESHOLD       0

#define FFT_MUL_TABLE  { 592, 1440, 2688, 5632, 14336, 40960, 0 }
#define FFT_MODF_MUL_THRESHOLD       608
#define FFT_MUL_THRESHOLD           5376

#define FFT_SQR_TABLE  { 656, 1504, 2944, 6656, 18432, 57344, 0 }
#define FFT_MODF_SQR_THRESHOLD       672
#define FFT_SQR_THRESHOLD           5376
