#! /bin/sh

target=i586-pc-msdosdjgpp
src=..
UPX_OPT=--best

#
#  Create various version strings we need.
#
#  EXAMPLE:
#
#  For gcc 3.0.2 20010828 (prerelease) we have:
#  	version = "3.0.2 20010828 (prerelease)"
#       short_version = "3.0.2"
#       dver = "3.02"
#       arcv = "302"
#
version=`cat $src/gcc/version.c | grep version_string | sed -e 's,^.*[=],,' | sed -e 's,[";],,g' | sed -e 's,^[\ ],,g'`
short_version=`echo $version | sed -e 's,[\ ].*,,' -e 's,^[ ]+,,g'`
dver=`echo $short_version | sed -e 's:\(3\.[0-9][0-9]*\)\.\(..*\):\1\2:g'`
arcv=`echo $short_version | sed -e 's,\.,,g'`

n_gcc=gcc${arcv}b
n_gpp=gpp${arcv}b
n_g77=g77${arcv}b
n_objc=objc${arcv}b
d_name=gcc-$dver
compiler_dir=lib/gcc-lib/djgpp/$dver

mv -v lib/libstdc++.a $compiler_dir/libstdcxx.a
mv -v lib/libsupc++.a $compiler_dir/libsupcxx.a
rm -vf `find . -name '*.la'`
mv -v lang/cxx-v3/$target lang/cxx-v3/djgpp
rm -v bin/gccbug
mv -f bin/g++.exe bin/gpp.exe
rm -v bin/djgpp-c++.exe bin/djgpp-g++.exe bin/djgpp-gcc.exe bin/c++.exe
mv -v bin/c++filt.exe bin/cxxfilt.exe
rm -v info/dir
mv -v man/man1/g++.1 man/man1/gpp.1

for x in `find . -name header.gcc`; do rm -v $x; done

for x in lang/cxx-v3/djgpp/bits/c++config.h:bits/cxxconfig.h \
	 lang/cxx-v3/djgpp/bits/c++io.h:bits/cxxio.h \
         lang/cxx-v3/djgpp/bits/c++locale.h:bits/cxxlocale.h \
         lang/cxx-v3/bits/std_cstdarg.h:bits/stdcstarg.h \
         lang/cxx-v3/bits/std_cstddef.h:bits/stdcstdef.h \
         lang/cxx-v3/bits/std_cstdio.h:bits/stdcstdio.h \
         lang/cxx-v3/bits/std_cstdlib.h:bits/stdcstdlib.h \
         lang/cxx-v3/bits/stl_algobase.h:bits/stlalgobase.h \
         lang/cxx-v3/ext/stl_hashtable.h:ext/stlhashtable.h  \
         lang/cxx-v3/bits/stl_iterator_base_funcs.h:bits/stl_itbf.h \
         lang/cxx-v3/bits/stl_iterator_base_types.h:bits/stl_itbt.h \
         lang/cxx-v3/bits/stl_multimap.h:bits/stlmltmap.h \
         lang/cxx-v3/bits/stl_multiset.h:bits/stlmltset.h \
         lang/cxx-v3/bits/valarray_meta.h:bits/valarr_m.h ; do
   curr1=`pwd`
   orig_file=`echo $x | sed -e 's,:.*,,g'`
   orig_name=`echo $orig_file | sed -e 's:.*/bits/:bits/:g' -e 's:.*/ext/:ext/:g'`	
   dir_name=`echo $orig_file | sed -e 's:/bits/.*::g' -e 's:/ext/.*::g'`
   new_name=`echo $x | sed -e 's|^.*:||g'`
   if cd $dir_name ; then 
       mv -v $orig_name $new_name && echo $orig_name $new_name >>header.gcc
       dir_name=`dirname $orig_name`
       orig_name=`basename $orig_name`
       new_name=`basename $new_name`
       echo $orig_name $new_name >>$dir_name/header.gcc
   fi
   cd $curr1
done

test -d gnu || mkdir gnu

libstdcxx_doc_list=
for x in `(cd $src/libstdc++-v3/docs && find html -type f)`; do
    item="libstdc++-v3/docs/$x:libstdcxx/`echo $x | sed -e 's,html/,,g'`";
    libstdcxx_doc_list="$libstdcxx_doc_list $item"
done

for x in        copying:copying \
                copying.lib:copying.lib \
                readme:readme \
		readme.DJGPP:readme.DJGPP \
                gcc/cp/news:gcc/cp/news \
                gcc/objc/readme:gcc/objc/readme \
                libf2c/permission.netlib:libf2c/permission.netlib \
                libf2c/readme:libf2c/readme \
                libf2c/readme.netlib:libf2c/readme.netlib \
                libf2c/todo:libf2c/todo \
                $libstdcxx_doc_list;  do
   orig_file=`echo $x | sed -e 's,:.*,,g'`
   new_file=`echo $x | sed -e 's,^.*:,,g'`
   dpos=gnu
   for y in `echo $d_name/\`dirname $new_file\` | tr '/' ' '`; do
       dpos="$dpos/$y"
       test -d $dpos || mkdir $dpos
   done
   cp -v $src/$orig_file gnu/$d_name/$new_file
done

( cd gnu/$d_name/libstdcxx/17_intro && mv -vf C++STYLE CXXSTYLE )
( cd gnu/$d_name/libstdcxx/17_intro && mv -vf libstdc++-assign.txt libstdcxx-assign.txt )
( cd gnu/$d_name/libstdcxx/27_io && mv -vf binary_iostreams_kanze.txt kanze_binary_iostreams.txt )
( cd gnu/$d_name/libstdcxx/27_io && mv -vf binary_iostreams_kuehl.txt kuehl_binary_iostreams.txt )
( cd gnu/$d_name/libstdcxx/21_strings && mv -vf stringtok_std_h.txt std_stringtok_h.txt )

upx $UPX_OPT `find . -name '*.exe' | sed -e 's,^\./,,g'`

for x in cc1.exe cc1plus.exe f771.exe cc1obj.exe; do
    stubedit lib/gcc-lib/djgpp/$dver/$x minstack=1024K
done

for x in gcc g2c stdcxx supcxx; do
    strip -g lib/gcc-lib/djgpp/$dver/lib$x.a
done

#  Fixes info files generated by makeinfo to fit in
#  MS-DOS 8+3 filename limits
#
for file in info/*.info-*; do
	mv $file `echo $file | sed -e 's,info-,i,'`; 
done

for file in info/*.info; do
	echo $file
  	cat $file | \
	awk 'substr($0,1,9)=="Indirect:" { active=1; } \
	     substr($0,1,10)=="Tag Table:" { active=0; } \
	     { if (active) gsub("info-","i"); \
               print $0 }' > $file.new
        mv -f $file.new $file
done


echo "Converting man pages ..."

for x in `find man -type f -and -name '*.[1-9]*'`; do
    case $x in 
#        man/man1/gpp.1)
#            ginstall -d man/cat1
#            cp man/man1/gpp.1 man/cat1
#            ;;
	man/man*)
	    echo `basename $x`
	    x1=`echo $x | sed -e 's,^man/,,g'`
            c1=`echo $x1 | sed -e 's,man\([1-9]\)/,cat\1/,g'`
            ginstall -d man/`dirname $c1`
	    ( cd man && groff -man -Tascii $x1 >$c1 )
            ;;
    esac
done

#  Look whether we have development version of GCC
DevName=`case $version in 
		*prerelease* | *experimental*)
			echo '(WARNING development version)'
		;;
	esac`

mkdir manifest
echo "$n_gcc.zip : GCC $version C compiler binaries for DJGPP $DevName" >manifest/$n_gcc.ver
echo "$n_gpp.zip : GCC $version C++ compiler binaries for DJGPP $DevName" >manifest/$n_gpp.ver
echo "$n_g77.zip : GCC $version Fortran compiler binaries for DJGPP $DevName" >manifest/$n_g77.ver
echo "$n_objc.zip : GCC $version Objective C compiler binaries for DJGPP $DevName" >manifest/$n_objc.ver

rm -f skipped.mft
for x in gcc gpp g77 objc; do
	rm -f manifest/${x}${arcv}b.mft
	touch manifest/${x}${arcv}b.mft
done

for x in dsmsrc/*.dsi; do
	dsm_name=`echo $x | \
		  sed -e 's/^dsmsrc//' -e "s:\([bs]\)\.dsi:$arcv\1.dsm:"`
	echo Creating $dsm_name
	cat $x | sed -e "s:@version@:$short_version:g" \
	             -e "s:@dver@:$dver:g" \
		     -e "s:@arcv@:$arcv:g" >manifest/$dsm_name
done

if make -C ../build.djg/gcc proto ; then
	upx --best ../build.djg/gcc/protoize.exe -o bin/protoize.exe
	upx --best ../build.djg/gcc/unprotoize.exe -o bin/unprotoize.exe
	cp -v ../build.djg/gcc/SYSCALLS.c.X lib/gcc-lib/djgpp/$dver/SYSCALLS.cX
fi

echo ''
echo 'Creating manifest files ...'
echo ''
for x in `find . -type f | sed -e 's,^\./,,g'`; do
	case $x in
		*/libstdcxx/*.css|\
		*/libstdcxx/Makefile)
			echo $x
			echo $x >>skipped.mft ;;
 
		manifest/objc*|\
		*/cc1obj.exe|\
                */gcc/objc/*|\
		*/libobjc.a|\
		*/objc/*)
			echo $x >>manifest/$n_objc.mft ;;

		info/g77*|\
		manifest/g77*|\
		*/f771.exe|\
		*/g2c.h|\
		*/cat1/g77.1|\
		*/g77.exe|\
                */gcc/f/*|\
                */libf2c/*|\
		*/libg2c.a|\
		*/libg2c.h)
			echo $x >>manifest/$n_g77.mft ;;

		*/gpp.exe|\
		*/cxxfilt.exe|\
                lang/cxx*|\
                */cc1plus.exe|\
		*/libstdcxx.a|\
                */libsupcxx.a|\
                manifest/gpp*|\
                */gcc/cp/*|\
                */libstdcxx/*)
			echo $x >>manifest/$n_gpp.mft ;;

		bin/gcc*|\
                bin/gcov*|\
		bin/protoize.exe|\
		bin/unprotoize.exe|\
                info/c-tree*|\
                info/cpp*|\
                info/gcc*|\
		*/cc1.exe|\
                */collect2.exe|\
                */cpp0.exe|\
                */tradcpp0.exe|\
		*/libgcc.a|\
		*/djgpp-x.djl|\
                *gnu/gcc-*/*|\
                */specs|\
		*/SYSCALLS.cX|\
		*/cat1/cpp.1|\
                */cat1/gcc.1|\
                */cat1/gcov.1|\
                *manifest/gcc*|\
		*/djgpp.ver|\
                */cpp.exe|\
                */include/iso646.h|\
                */include/limits.h|\
		*/include/proto.h|\
		*/include/readme|\
                */include/stdbool.h|\
		*/include/stdarg.h|\
		*/include/varargs.h|\
		*/include/stddef.h|\
		*/include/varargs.h|\
                */include/syslimits.h|\
		*/include/wchar.h|\
		*/readme.DJGPP)
			echo $x >>manifest/$n_gcc.mft ;;

		*)
			echo $x
			echo $x >>skipped.mft ;;
	esac
done

echo ''
echo 'Building binary archives...'
echo ''

for x in manifest/*.mft; do 
	cat $x | sort > $x.new
	mv -f $x.new $x
	zipname=`basename $x | sed -e 's,mft,zip,g'`
        echo Building $zipname ...
	cat $x | zip -9@ $zipname
done
	