/* Configuration for GNU C-compiler for Intel 80386 running DJGPP.
   Copyright (C) 1988, 1996, 1998, 1999 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#define __MSDOS__ 1

#include "i386/xm-i386.h"

/* Use semicolons to separate elements of a path.  */
#define PATH_SEPARATOR ';'

#define EXECUTABLE_SUFFIX ".exe"

/* Even though we support "/", allow "\" since everybody tests both.  */
#define DIR_SEPARATOR '/'
#define DIR_SEPARATOR_2 '\\'

/* Allow test for DOS drive names.  */
#define HAVE_DOS_BASED_FILE_SYSTEM

/* System dependant initialization for collect2
   to tell system() to act like Unix.  */
#define COLLECT2_HOST_INITIALIZATION \
  do { __system_flags |= (__system_allow_multiple_cmds			\
		          | __system_emulate_chdir); } while (0)

/* Redefine name of xref file for DJGPP as original one is invalid for  
   plain MS-DOS  */
#undef XREF_FILE_NAME
#define XREF_FILE_NAME(xref_file,file) \
  do { 	char *w; \
	strcpy (xref_file,file); \
	w = strchr(basename(xref_file),'.'); if (w) *w=0; \
	strcat (xref_file,".gxref"); \
	} while (0)

/* Search for as.exe and ld.exe in DJGPP's binary directory. */ 
#define MD_EXEC_PREFIX "$DJDIR/bin/"

/* Where to look for DJGPP includes  */
#undef STANDARD_INCLUDE_DIR 
#define STANDARD_INCLUDE_DIR "$DJDIR/include"

#undef STANDARD_INCLUDE_COMPONENT
#define STANDARD_INCLUDE_COMPONENT ""

/* Correctly handle absolute filename detection in cp/xref.c */
#define FILE_NAME_ABSOLUTE_P(NAME) \
        (((NAME)[0] == '/') || ((NAME)[0] == '\\') || \
        (((NAME)[0] >= 'A') && ((NAME)[0] <= 'z') && ((NAME)[1] == ':')))

