/* Macros to help hide the file system differences between Unix, Windows,
   and other operating systems.

   Copyright (C) 2001 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef FILE_SYS_H
#define FILE_SYS_H

/* If both DIR_SEPARATOR and PATH_SEPARATOR are already defined,
   assume that HAVE_DOS_BASED_FILE_SYSTEM and DIR_SEPARATOR_2 have also
   been defined when appropriate. This is to allow a file or package like GCC
   to provide its own settings.  */
#if !(defined (DIR_SEPARATOR) && defined (PATH_SEPARATOR))

/* Define the directory separator.  */
#ifndef DIR_SEPARATOR
#define DIR_SEPARATOR '/'
#endif

/* Define DIR_SEPARATOR_2 for DOS, Windows, and OS/2 because they also use
   '\' as a directory separator. Define HAVE_DOS_BASED_FILE_SYSTEM to
   enable code that handles drive letters and other oddities.  */
#if defined (_WIN32) || defined (__MSDOS__) || defined (__OS2__)
#ifndef HAVE_DOS_BASED_FILE_SYSTEM
#define HAVE_DOS_BASED_FILE_SYSTEM
#endif
#ifndef DIR_SEPARATOR_2
#define DIR_SEPARATOR_2 '\\'
#endif
#endif /* _WIN32 || __MSDOS__ || __OS2__ */

/* Define PATH_SEPARATOR. Unix and Unix emulators (such as Cygwin) use ':'
   to separate paths while DOS, Windows, and OS/2 use ';'.  */
#ifndef PATH_SEPARATOR
#if defined (HAVE_DOS_BASED_FILE_SYSTEM) && !defined (__unix__)
#define PATH_SEPARATOR ';'
#else /* !HAVE_DOS_BASED_FILE_SYSTEM || __unix__ */
#define PATH_SEPARATOR ':'
#endif /* !HAVE_DOS_BASED_FILE_SYSTEM || __unix__ */
#endif /* !PATH_SEPARATOR */

#endif /* ! (DIR_SEPARATOR && PATH_SEPARATOR) */

/* Define IS_DIR_SEPARATOR.  Determines if a character is
   a directory separator.  */
#ifndef DIR_SEPARATOR_2
#define IS_DIR_SEPARATOR(ch) ((ch) == DIR_SEPARATOR)
#else /* DIR_SEPARATOR_2 */
#define IS_DIR_SEPARATOR(ch) \
  (((ch) == DIR_SEPARATOR) || ((ch) == DIR_SEPARATOR_2))
#endif /* DIR_SEPARATOR_2 */

/* Define IS_PATH_SEPARATOR.  Determines if a character is
   a path separator.  */
#define IS_PATH_SEPARATOR(ch) ((ch) == PATH_SEPARATOR)

/* Define IS_ABSOLUTE_PATHNAME. Determines if a path is absoltue.  */
#ifdef HAVE_DOS_BASED_FILE_SYSTEM
#define IS_ABSOLUTE_PATHNAME(f) \
  (IS_DIR_SEPARATOR(*(f)) \
   || ((f)[0] != '\0' && (f)[1] == ':' && IS_DIR_SEPARATOR((f)[2])))
#else
#define IS_ABSOLUTE_PATHNAME(f) (IS_DIR_SEPARATOR(*(f)))
#endif

/* Provide IS_ABSOLUTE_PATH for Binutils.  */
#define IS_ABSOLUTE_PATH(f) IS_ABSOLUTE_PATHNAME(f)

/* Define IS_DOS_STYLE_RELATIVE_PATH.  Determines if path is
   a DOS-style relative path that takes the form 'x:foo/bar'.  */
#ifdef HAVE_DOS_BASED_FILE_SYSTEM
#define IS_DOS_STYLE_RELATIVE_PATH(f) \
  ((f)[0] != '\0' && (f)[1] == ':' && !IS_DIR_SEPARATOR((f)[2]))
#endif

/* Define HAS_DRIVE_NAME. Determines if a path starts with
   a DOS-style drive name.  */
#ifdef HAVE_DOS_BASED_FILE_SYSTEM
#define IS_DOS_STYLE_DRIVE_NAME(f) ((*(f) != '\0') && ((f)[1] == ':'))
#else
#define IS_DOS_STYLE_DRIVE_NAME(f) (0)
#endif

/* Define IS_SAME_PATH. Determine if two paths match.
   Unix filenames are case-sensitive, while MS Windows filenames are not
   (even though it preserves case). Therefore, the method of comparing the
   filenames must differ. This macro assumes the two filenames have already
   been canonicalized somehow.  */
#ifdef HAVE_DOS_BASED_FILE_SYSTEM
#define IS_SAME_PATH(s1, s2) (strcasecmp((s1), (s2)) == 0)
#else
#define IS_SAME_PATH(s1, s2) (strcmp((s1), (s2)) == 0)
#endif

/* Define IS_SAME_PATH_CHAR. Determine if two path elements match.  */
#ifdef HAVE_DOS_BASED_FILE_SYSTEM
#define IS_SAME_PATH_CHAR(a,b) (toupper (a) == toupper (b))
#else
#define IS_SAME_PATH_CHAR(a,b) ((a) == (b))
#endif

#endif /* FILE_SYS_H */
