#! bash
### Time-stamp: <lfn2sfn-change.sh: 10 JUN 1999   0:27 (rjvdboon)>
### A little exercise in bash...
export SCRTMPFIL=_ttmmpp.rj
function _rjmv2() {
  if [ $# -ne 2 ] ; then
    echo "usage: _rjmv2 OldName NewName" 1>&2
    return 1
  fi
  if [ -f $1 ] ; then
    if [ "$1" = "$2" ] ; then
      echo "_rjmv2: \`$1' and \`$2' are the same." 1>&2
      return 1
    else
      echo _rjmv2: mv $1 $2
      mv $1 $2
    fi
  else
      echo "_rjmv2: \`$1' does not exist! Did you execute me already?" 1>&2
      return 1
  fi 
}

## Note, we treat config.h.in further down the script.
echo Renaming some files that would clash with other files when taken in the
echo 8.3 convention, or have to many dots. \(Disallowed on sfn-DOS\)...
_rjmv2 ./examples/scripts.noah/bash.sub.bash ./examples/scripts.noah/bash_sub.bash
_rjmv2 ./examples/functions/basename2 ./examples/functions/basenam2
_rjmv2 ./tests/run-array2             ./tests/run-arr2
_rjmv2 ./tests/run-histexpand         ./tests/run-hisxpand
_rjmv2 ./tests/run-posixpat           ./tests/run-psxpat
_rjmv2 ./examples/scripts/scrollbar2  ./examples/scripts/scrollb2

echo Changing references to bash.sub.bash in all files...
for f in \
  ./examples/scripts.noah/bash_sub.bash \
  ./examples/scripts.noah/readme \
  ./manifest
do
  sed -e 's/bash\.sub/bash_sub/g' $f > ${SCRTMPFIL} \
    && update ${SCRTMPFIL} $f \
    && rm ${SCRTMPFIL}
done

echo Now changing these file references in manifest...
sed -e 's%basename2%basenam2%g'          \
    -e 's%run-array2%run-arr2%g'         \
    -e 's%run-histexpand%run-hisxpand%g' \
    -e 's%run-posixpat%run-psxpat%g'     \
    -e 's%scrollbar2%scrollb2%g'      ./manifest > ${SCRTMPFIL} && \
 update ${SCRTMPFIL} ./manifest && \
  rm ${SCRTMPFIL}

echo Now patching ./tests/run-minimal...
sed -e 's%run-posixpat%run-psxpat%g' ./tests/run-minimal > ${SCRTMPFIL} \
  && update ${SCRTMPFIL} ./tests/run-minimal \
  && rm ${SCRTMPFIL}

if [ -f ./lib/termcap/grot/termcap.info-1 ] ; then
  echo "Need to remake ./lib/termcap/grot/termcap.info with --no-split, because the"
  echo "following files all resolve to termcap.inf on sfn-DOS:"
  echo "./lib/termcap/grot/termcap.info"
  echo "./lib/termcap/grot/termcap.info-*"
  echo Now changing to directory ./lib/termcap/grot/
  cd ./lib/termcap/grot
  rm termcap.info* && makeinfo --no-split termcap.texi
  echo Patch makefile.in to include --no-split at makeinfo invocation...
  sed -e 's%\$(MAKEINFO) \$(srcdir)%$(MAKEINFO) --no-split $(srcdir)%g' ./makefile.in > ${SCRTMPFIL} \
    && update ${SCRTMPFIL} ./makefile.in \
    && rm ${SCRTMPFIL}
  cd -
  echo Returned to the previous directory...
fi

echo Change references of .patchlevel to _patchlevel,
echo .distribution to _distribution, .build to _build and .made to _made...
for f in \
  ./configure.in \
  ./install \
  ./readme \
  ./Makefile.in \
  ./doc/bashref.info \
  ./support/mkclone \
  ./support/mkconffiles \
  ./support/mkversion.sh
do
  sed -e 's%\.patchlevel%_patchlevel%g' \
      -e 's%\.distribution%_distribution%g' \
      -e 's%\.build%_build%g' \
      -e 's%\.made%_made%g' $f > ${SCRTMPFIL} \
    && update ${SCRTMPFIL} $f \
    && rm ${SCRTMPFIL}
done

if [ -f ./config.h.in ] ; then
  echo I will mv config.h.in to config.h-in
  mv ./config.h.in ./config.h-in
fi
echo Change references of config.h.in to config.h-in...
for f in \
  ./AUTHORS            \
  ./config.h-in        \
  ./configure.in       \
  ./configure          \
  ./Makefile.in        \
  ./Makefile           \
  ./MANIFEST           \
  ./tests/errors.tests \
  ./support/missing
do
  sed -e 's%config\.h\.in%config.h-in%g' \
      -e 's%HEADER(config\.h)%HEADER(config.h:config.h-in)%g' \
       $f > ${SCRTMPFIL} \
    && update ${SCRTMPFIL} $f \
    && rm ${SCRTMPFIL}
done

echo Straightforward patches to AUTHORS, MANIFEST will be applied
echo to change y.tab to y_tab
for f in \
  ./AUTHORS \
  ./MANIFEST
do
  sed -e 's%y.tab%y_tab%g' $f > ${SCRTMPFIL} \
    && update ${SCRTMPFIL} $f \
    && rm ${SCRTMPFIL}
done

echo The files in the ./support/ branch, and parse.y are deliberately
echo not changed.
