/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
/*
 $Id: idedefau.cc,v 1.2 1997-09-08 22:51:57+00 rho Exp rho $
*/
#define Uses_TOptions
#define Uses_TProject
#define Uses_TStringCollection
#define Uses_TFlagEntry
#define Uses_TFlagCollection
#include <libide.h>
#include <rhide.h>

#define F(x) x,
static char *c_flags[] = {
  #include "flags/c_opt.h"
  NULL
};

static char *cxx_flags[] = {
  #include "flags/cxx_opt.h"
  NULL
};

static char *warn_flags[] = {
  #include "flags/warn_opt.h"
  NULL
};

static char *opt_flags[] = {
  #include "flags/opt_opt.h"
  NULL
};

static char * debug_flags[] = {
  #include "flags/deb_opt.h"
  NULL
};

static char *reserved[] = {
  #include "flags/reserved.h"
  NULL
};

static char *GPCreserved[] = {
  #include "flags/gpcreser.h"
  NULL
};

static char *pascal_flags[] = {
  #include "flags/pas_opt.h"
  NULL
};

static char *fortran_flags[] = {
  #include "flags/f_opt.h"
  NULL
};

static char *ada_flags[] = {
  #include "flags/ada_opt.h"
  NULL
};

#undef F

static void InitOptions(char *opts[],TFlagCollection * & coll)
{
  int i;
  coll = new TFlagCollection();
  i = 0;
  while (opts[i])
  {
    coll->insert(new TFlagEntry(opts[i]));
    i++;
  }
}

#define GETFLAGS(lower,upper)\
void Default##upper##Flags()\
{\
  if (Options.##lower##_flags) destroy(Options.##lower##_flags);\
  InitOptions(lower##_flags,Options.##lower##_flags);\
}

GETFLAGS(opt,Opt)
GETFLAGS(warn,Warn)
GETFLAGS(debug,Debug)
GETFLAGS(cxx,CXX)
GETFLAGS(c,C)
GETFLAGS(pascal,Pascal)
GETFLAGS(fortran,Fortran)
GETFLAGS(ada,Ada)

void DefaultReservedWords()
{
  int i;
  ccIndex index;
  if (CReservedWords) destroy(CReservedWords);
  CReservedWords = new TStringCollection(1,1);
  i = 0;
  while (reserved[i])
  {
    if (CReservedWords->search(reserved[i],index) == False)
      CReservedWords->insert(newStr(reserved[i]));
    i++;
  }
  c_words_changed = 1;
}

void DefaultGPCReservedWords()
{
  int i;
  ccIndex index;
  if (GPCReservedWords) destroy(GPCReservedWords);
  GPCReservedWords = new TStringCollection(1,1);
  i = 0;
  while (GPCreserved[i])
  {
    if (GPCReservedWords->search(GPCreserved[i],index) == False)
      GPCReservedWords->insert(newStr(GPCreserved[i]));
    i++;
  }
  gpc_words_changed = 1;
}

void DefaultUserWords()
{
  if (RHIDEUserWords) destroy(RHIDEUserWords);
  RHIDEUserWords = new TStringCollection(5,5);
  user_words_changed = 1;
}

