@17140@
@13830@
@13245@
@13635@
@13440@
@13245@

Modified by Robert Hhne to be used for RHIDE.

@13245@
@13245@
@14024@

#ifdef __DJGPP__

@14609@
@14293@
@16849@

@16697@
#include <malloc.h>
#include <go32.h>
#include <dpmi.h>
#include <sys/farptr.h>
#include <sys/movedata.h>
#define REGS __dpmi_regs

@16675@
#include <pc.h>
@16745@
#include <sys/mono.h>

@21375@
@21374@
ushort TScreen::screenMode = 0xFFFF;
@21321@
@21320@
uchar TScreen::Page = 0;
@19109@
@19107@
long TScreen::screenBuffer = -1;
@21371@

extern REGS r_display;

#define r (r_display)
#define AL (r.h.al)
#define BL (r.h.bl)
#define DL (r.h.dl)
#define AH (r.h.ah)
#define BH (r.h.bh)
#define DH (r.h.dh)
#define AX (r.x.ax)
#define BX (r.x.bx)
#define CX (r.x.cx)
#define DX (r.x.dx)

int TScreen_suspended = 1;

void SaveScreen();
void RestoreScreen();
void ScreenUpdate();
extern ushort user_mode;

static inline
unsigned char I(unsigned char i)
@23372@
  outportb(0x3b4,i);
  return inportb(0x3b5);
@24151@

static inline
void O(unsigned char i,unsigned char b)
@23372@
  outportb(0x3b4,i);
  outportb(0x3b5,b);
@24151@

void TScreen::GetCursor(int &x,int &y)
@23372@
  if (dual_display)
@12966@
@12978@
@12774@
@12966@
    TDisplay::GetCursor(x,y);
@12978@
@24151@

void TScreen::SetCursor(int x,int y)
@23372@
  if (dual_display || screenMode == 7)
@12966@
    unsigned short loc = y*80+x;
    O(0x0e,loc >> 8);
    O(0x0f,loc & 0xff);
@12978@
@12774@
@12966@
    TDisplay::SetCursor(x,y);
@12978@
@24151@

static int was_blink = 0;
void setBlinkState();
void setIntenseState();
int getBlinkState();

@19514@
@23372@
  screenMode = startupMode = getCrtMode();
  resume();
@24151@

@21810@
@23372@
  if (!TScreen_suspended) return;
  if (!dual_display)
@12966@
    SaveScreen();
    if (screenMode == 0xffff)
      screenMode = getCrtMode();
    if (screenMode != user_mode)
      setCrtMode( screenMode );
    if (was_blink)
      setBlinkState();
@07986@
      setIntenseState();
@12978@
@12774@
@12966@
    extern int emulate_mouse;
    emulate_mouse = 1;
@12978@
  setCrtData();
  TScreen_suspended = 0;
@24151@

@19515@
@23372@
  suspend();
//  setCrtMode(startupMode);
//  textmode(startupMode);
//  if (startupMode == user_mode)
//    ScreenUpdate();
@24151@

@21813@
@23372@
  if (TScreen_suspended) return;
  if (!dual_display)
@12966@
    was_blink = getBlinkState();
    RestoreScreen();
@12978@
  TScreen_suspended = 1;
@24151@

@21372@
@23372@
  return mode;
@24151@

@21811@
@23372@
  if (dual_display)
@12966@
    screenMode = 7;
    screenWidth = 80;
    screenHeight = 25;
    cursorLines = 0x0b0c;
@12978@
@12774@
@12966@
@10361@
@10362@
@10360@
@08479@
    if (screenMode == 7)
      cursorLines = 0x0b0c;
@07986@
      cursorLines = 0x0607;
    setCursorType( 0x2000 );
@12978@
@24151@

@21809@
@23372@
  if (dual_display)
    _mono_clear();
@12774@
@06635@
@24151@

@21812@
@23372@
@10417@
@10415@
@24151@

void TScreen::setCursorType(ushort ct)
@23372@
  if (dual_display || screenMode == 7)
@12966@
    if (ct == 0x2000) // cursor off
@12247@
      O(0x0a,0x01);
      O(0x0b,0x00);
@12539@
@07986@
@12247@
      O(0x0a,ct >> 8);
      O(0x0b,ct & 0xff);
@12539@
@12978@
@12774@
@12966@
    TDisplay::setCursorType(ct);
@12978@
@24151@

ushort TScreen::getCursorType()
@23372@
  if (dual_display || screenMode == 7)
@12966@
    unsigned short ct;
    ct = (I(0x0a) << 8) | I(0x0b);
    if (!ct) ct = 0x2000;
    return ct;
@12978@
@12774@
@12966@
    return TDisplay::getCursorType();
@12978@
@24151@

ushort TScreen::getRows()
@23372@
  return dual_display ? 25 : TDisplay::getRows();
@24151@

ushort TScreen::getCols()
@23372@
  return dual_display ? 80 : TDisplay::getCols();
@24151@

int slow_screen = 0;

ushort TScreen::getCharacter(unsigned offset)
@23372@
  return _farpeekw(_dos_ds,(dual_display ? 0xb0000 : ScreenPrimary)+offset*2);
@24151@

void TScreen::getCharacter(unsigned offset,ushort *buf,unsigned count)
@23372@
  if (slow_screen)
@12966@
    _farsetsel(_dos_ds);
    int ofs = dual_display ? 0xb0000 : ScreenPrimary+offset*2;
    while (count--)
@12247@
      *buf++ = _farnspeekw(ofs);
      ofs += 2;
@12539@
@12978@
@12774@
@12966@
    movedata(_dos_ds,(dual_display ? 0xb0000 : ScreenPrimary)+offset*2,
             _my_ds(),(int)buf,count*2);
@12978@
@24151@

void TScreen::setCharacter(unsigned offset,ushort value)
@23372@
  _farpokew(_dos_ds,(dual_display ? 0xb0000 : ScreenPrimary)+offset*2,value);
@24151@

void TScreen::setCharacter(unsigned offset,ushort *values,unsigned count)
@23372@
  if (slow_screen)
@12966@
    _farsetsel(_dos_ds);
    int ofs = dual_display ? 0xb0000 : ScreenPrimary+offset*2;
    while (count--)
@12247@
      _farnspokew(ofs,*values++);
      ofs += 2;
@12539@
@12978@
@12774@
@12966@
    movedata(_my_ds(),(int)values,_dos_ds,
             (dual_display ? 0xb0000 : ScreenPrimary)+offset*2,count*2);
@12978@
@24151@

#endif // __DJGPP__

