/*****************************************************************************

    Class: TNoCaseStringCollection

    Description: Is a TStringCollection but no case sensintive.

    Class: TNoCaseNoOwnerStringCollection

    Description: Is a TStringCollection but no case sensintive, and isn't
                 the owner ship, is used when the item MUST NOT be free.

    Class: TNoCaseSOSStringCollection

    Description: Is like TNoCaseNoOwnerStringCollection but the inserted
                 values are stkHandlers instead of pointers.

    by SET

*****************************************************************************/

#ifndef __SET_TNoCasTC_H__
#define __SET_TNoCasTC_H__

#ifndef __SET_SOStack_H__
#include "setstack.h"
#endif

#define SetDefStreamOperators(a) \
inline ipstream& operator >> ( ipstream& is, a& cl )   \
    { return is >> (TStreamable&)cl; }                 \
inline ipstream& operator >> ( ipstream& is, a*& cl )  \
    { return is >> (void *&)cl; }                      \
                                                       \
inline opstream& operator << ( opstream& os, a& cl )   \
    { return os << (TStreamable&)cl; }                 \
inline opstream& operator << ( opstream& os, a* cl )   \
    { return os << (TStreamable *)cl; }

#define SetDefStreamMembers(a,b) \
private:                                                             \
    virtual const char *streamableName() const                       \
        { return name; }                                             \
    virtual void *readItem( ipstream& is );                          \
    virtual void writeItem( void *obj, opstream& os );               \
protected:                                                           \
    a( StreamableInit ) : b( streamableInit ) {};                    \
public:                                                              \
    static const char * const name;                                  \
    static TStreamable *build() {return new a( streamableInit );};


class TNoCaseStringCollection : public TStringCollection
{
public:

 TNoCaseStringCollection(ccIndex aLimit, ccIndex aDelta) :
      TStringCollection(aLimit,aDelta) {};
 int compare(void *s1,void *s2) { return strcasecmp((char *)s1,(char *)s2); };

 SetDefStreamMembers(TNoCaseStringCollection,TStringCollection)
};

SetDefStreamOperators(TNoCaseStringCollection)


class TNoCaseNoOwnerStringCollection : public TStringCollection
{
public:
 TNoCaseNoOwnerStringCollection(ccIndex aLimit, ccIndex aDelta) :
      TStringCollection(aLimit,aDelta) {};
 int compare(void *s1,void *s2) { return strcasecmp((char *)s1,(char *)s2); };
 void freeItem(void *) {};
};

class TNoCaseSOSStringCollection : public TStringCollection
{
public:
 TNoCaseSOSStringCollection(ccIndex aLimit, ccIndex aDelta, SOStack *stk) :
      TStringCollection(aLimit,aDelta)
 { stkL=stk; };
 int compare(void *s1,void *s2);
 void freeItem(void *) {};
 Boolean Search( char *key, ccIndex& index );
 void insert(stkHandler h) { TStringCollection::insert((void *)h); };
 char *atStr(ccIndex index) { return GetString(at(index)); };
 virtual char *GetString( void *h );
 SOStack *stkL;
};

class TSOSSortedListBox : public TSortedListBox
{
 public:
 TSOSSortedListBox(const TRect& bounds, ushort aNumCols,
                   TScrollBar *aScrollBar) :
 TSortedListBox(bounds,aNumCols,aScrollBar)
 { SearchPos=USHRT_MAX; ShiftState=0; };
 void getText(char *dest, ccIndex item, short maxLen);
 void handleEvent(TEvent& event);

 private:
 ushort SearchPos;
 int ShiftState;
};

#endif
