;********************************************************************
; Date Revised: March 14, 2003.
; Program Name: Mxlhws.asm for Mxlhws.com
;********************************************************************
;
; Author       : JOHN F. CLARK JR.
; I can be contacted by mail at......
; Address      : 11-15 Port Richmond Av. Statem Island NY 10302
;
; *****************************************************
; [ Appendix: Terms Conditions and Aggreements ]
; *****************************************************
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;                       NO WARRANTY
; BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
; FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
; OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
; PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
; OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
; MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
; TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
; PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
; REPAIR OR CORRECTION.
;
; IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
; WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
; REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
; INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
; OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
; TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
; YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
; PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGES.
;                    END OF TERMS AND CONDITIONS
;***************************************************************************
;
;
;Set Code Start Address To 100h
org 0100h

;Set Code Data Segment
segment .data
    msg db 'MXLHWS Hardware Reset For Mxloder',0Dh, 0Ah,'$'

;Set Code Segment
segment .text

    ;Set Up Stacks
    push bp
    mov bp, sp

    ;Save Registers
    push ax
    push bx
    push cx
    push dx
    push ds
    push es

    ;Clear General Registers
    xor ax, ax
    xor bx, bx
    xor cx, cx
    xor dx, dx

    ;Output Screen Message
    mov dx, msg
    mov ah, 9
    int 21h
    xor ax, ax
    xor dx, dx

    ;Code For Hardware Reset Operation
    mov ah, 0Ch
    mov al, 00h
    int 21h
    mov dx, 0040h
    mov ds, dx
    mov es, dx
    push si
    push di
    mov si, 017h
    mov al, [si]
    mov bl, 8Fh
    and al, bl
    mov di, 017h
    mov [di], al
    pop di
    pop si
    mov ah, 0Ch
    mov al, 00h
    int 21h
    mov bx, 0040h
    mov ds, bx
    mov es, bx
    mov dx, 0017h
    mov si, dx
    mov di, dx
    mov al, [si]
    mov bl, 199
    and al, bl
    mov ax, 0020h
    int 33h

    ;Restore Registers
    pop es
    pop ds
    pop dx
    pop cx
    pop bx
    pop ax
    pop bp

    ;Close Down
    mov ax, 4C00h
    int 21h
    ;End
;
; : Enjoy Micro-x : John F. Clark Jr. :
